/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.HttpChecksumProperty;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class HttpChecksumTrait
extends AbstractTrait
implements ToSmithyBuilder<HttpChecksumTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#httpChecksum");
    private static final String REQUEST_PROPERTY = "request";
    private static final String RESPONSE_PROPERTY = "response";
    private final List<HttpChecksumProperty> requestProperties;
    private final List<HttpChecksumProperty> responseProperties;

    private HttpChecksumTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.requestProperties = ListUtils.copyOf((Collection)builder.requestProperties);
        this.responseProperties = ListUtils.copyOf((Collection)builder.responseProperties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public SmithyBuilder<HttpChecksumTrait> toBuilder() {
        return ((Builder)new Builder().sourceLocation(this.getSourceLocation())).requestProperties(this.getRequestProperties()).responseProperties(this.getResponseProperties());
    }

    public List<HttpChecksumProperty> getRequestProperties() {
        return this.requestProperties;
    }

    public Set<String> getRequestAlgorithms() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        this.requestProperties.forEach(p -> set.add(p.getAlgorithm()));
        return set;
    }

    public List<HttpChecksumProperty> getRequestPropertiesForAlgorithm(String algorithm) {
        ArrayList<HttpChecksumProperty> list = new ArrayList<HttpChecksumProperty>();
        for (HttpChecksumProperty property : this.requestProperties) {
            if (!property.getAlgorithm().equalsIgnoreCase(algorithm)) continue;
            list.add(property);
        }
        return list;
    }

    public List<HttpChecksumProperty> getResponseProperties() {
        return this.responseProperties;
    }

    public Set<String> getResponseAlgorithms() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        this.responseProperties.forEach(p -> set.add(p.getAlgorithm()));
        return set;
    }

    public List<HttpChecksumProperty> getResponsePropertiesForAlgorithm(String algorithm) {
        ArrayList<HttpChecksumProperty> list = new ArrayList<HttpChecksumProperty>();
        for (HttpChecksumProperty property : this.responseProperties) {
            if (!property.getAlgorithm().equalsIgnoreCase(algorithm)) continue;
            list.add(property);
        }
        return list;
    }

    @Override
    protected Node createNode() {
        ObjectNode.Builder builder = ObjectNode.objectNodeBuilder();
        builder.sourceLocation(this.getSourceLocation());
        if (!this.requestProperties.isEmpty()) {
            builder.withMember(REQUEST_PROPERTY, (ToNode)this.getRequestProperties().stream().map(HttpChecksumProperty::toNode).collect(ArrayNode.collect()));
        }
        if (!this.responseProperties.isEmpty()) {
            builder.withMember(RESPONSE_PROPERTY, (ToNode)this.getResponseProperties().stream().map(HttpChecksumProperty::toNode).collect(ArrayNode.collect()));
        }
        return builder.build();
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            Optional<ArrayNode> responseNodes;
            ObjectNode objectNode = value.expectObjectNode();
            Builder builder = (Builder)HttpChecksumTrait.builder().sourceLocation(value);
            Optional<ArrayNode> requestNodes = objectNode.getArrayMember(HttpChecksumTrait.REQUEST_PROPERTY);
            if (requestNodes.isPresent()) {
                List<HttpChecksumProperty> properties = requestNodes.get().getElementsAs(HttpChecksumProperty::fromNode);
                for (HttpChecksumProperty property : properties) {
                    builder.addRequestProperty(property);
                }
            }
            if ((responseNodes = objectNode.getArrayMember(HttpChecksumTrait.RESPONSE_PROPERTY)).isPresent()) {
                List<HttpChecksumProperty> properties = responseNodes.get().getElementsAs(HttpChecksumProperty::fromNode);
                for (HttpChecksumProperty property : properties) {
                    builder.addResponseProperty(property);
                }
            }
            return builder.build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<HttpChecksumTrait, Builder> {
        private List<HttpChecksumProperty> requestProperties = new ArrayList<HttpChecksumProperty>();
        private List<HttpChecksumProperty> responseProperties = new ArrayList<HttpChecksumProperty>();

        private Builder() {
        }

        public HttpChecksumTrait build() {
            return new HttpChecksumTrait(this);
        }

        public Builder requestProperties(List<HttpChecksumProperty> properties) {
            this.clearRequestProperties();
            properties.forEach(this::addRequestProperty);
            return this;
        }

        public Builder addRequestProperty(HttpChecksumProperty property) {
            this.requestProperties.add(property);
            return this;
        }

        public Builder clearRequestProperties() {
            this.requestProperties.clear();
            return this;
        }

        public Builder responseProperties(List<HttpChecksumProperty> properties) {
            this.clearResponseProperties();
            properties.forEach(this::addResponseProperty);
            return this;
        }

        public Builder addResponseProperty(HttpChecksumProperty property) {
            this.responseProperties.add(property);
            return this;
        }

        public Builder clearResponseProperties() {
            this.responseProperties.clear();
            return this;
        }
    }
}

