/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.StringTokenizer;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.pattern.InvalidPatternException;
import software.amazon.smithy.model.pattern.SmithyPattern;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class EndpointTrait
extends AbstractTrait
implements ToSmithyBuilder<EndpointTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#endpoint");
    private final SmithyPattern hostPrefix;

    private EndpointTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        String hostPrefix = Objects.requireNonNull(builder.hostPrefix, "hostPrefix not set");
        StringTokenizer tokenizer = new StringTokenizer(hostPrefix, "{}", true);
        ArrayList<SmithyPattern.Segment> segments = new ArrayList<SmithyPattern.Segment>();
        int position = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("{")) {
                if (!segments.isEmpty() && ((SmithyPattern.Segment)segments.get(segments.size() - 1)).isLabel()) {
                    throw new InvalidPatternException(String.format("Host labels must not be adjacent in a pattern. Found %s", hostPrefix));
                }
                for (int i = 0; i < 2; ++i) {
                    if (!tokenizer.hasMoreTokens()) {
                        throw new InvalidPatternException("Unclosed label found in pattern at: ." + position);
                    }
                    token = token + tokenizer.nextToken();
                }
            } else if (token.equals("}")) {
                throw new InvalidPatternException("Literal segments must not contain `}`. Found at: " + position);
            }
            segments.add(SmithyPattern.Segment.parse(token, position));
            position += token.length();
        }
        this.hostPrefix = SmithyPattern.builder().allowsGreedyLabels(false).segments(segments).pattern(hostPrefix).build();
    }

    public SmithyPattern getHostPrefix() {
        return this.hostPrefix;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)new Builder().sourceLocation(this.getSourceLocation())).hostPrefix(this.hostPrefix.toString());
    }

    @Override
    protected Node createNode() {
        return new ObjectNode(Collections.emptyMap(), this.getSourceLocation()).withMember("hostPrefix", Node.from(this.hostPrefix.toString()));
    }

    public static final class Builder
    extends AbstractTraitBuilder<EndpointTrait, Builder> {
        private String hostPrefix;

        private Builder() {
        }

        public Builder hostPrefix(String hostPrefix) {
            this.hostPrefix = hostPrefix;
            return this;
        }

        public EndpointTrait build() {
            return new EndpointTrait(this);
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)EndpointTrait.builder().sourceLocation(value);
            ObjectNode objectNode = value.expectObjectNode();
            builder.hostPrefix(objectNode.expectStringMember("hostPrefix").getValue());
            return builder.build();
        }
    }
}

