/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ListUtils;

public final class AuthTrait
extends AbstractTrait {
    public static final ShapeId ID = ShapeId.from("smithy.api#auth");
    private final List<ShapeId> values;

    public AuthTrait(List<ShapeId> values, FromSourceLocation sourceLocation) {
        super(ID, sourceLocation);
        this.values = ListUtils.copyOf(values);
    }

    public AuthTrait(List<ShapeId> values) {
        this(values, (FromSourceLocation)SourceLocation.NONE);
    }

    public List<ShapeId> getValues() {
        return this.values;
    }

    @Override
    protected Node createNode() {
        return this.getValues().stream().map(ShapeId::toString).map(Node::from).collect(ArrayNode.collect(this.getSourceLocation()));
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            ArrayList<ShapeId> values = new ArrayList<ShapeId>();
            for (StringNode node : value.expectArrayNode().getElementsAs(StringNode.class)) {
                values.add(node.expectShapeId());
            }
            return new AuthTrait(values, (FromSourceLocation)value.getSourceLocation());
        }
    }
}

