/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.HttpChecksumProperty;
import software.amazon.smithy.model.traits.HttpChecksumTrait;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class HttpChecksumTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        TopDownIndex topDownIndex = TopDownIndex.of(model);
        List services = model.shapes(ServiceShape.class).collect(Collectors.toList());
        for (ServiceShape service : services) {
            for (OperationShape operation : topDownIndex.getContainedOperations(service)) {
                if (!operation.hasTrait(HttpChecksumTrait.class)) continue;
                events.addAll(this.validateOperation(model, service, operation));
            }
        }
        return events;
    }

    private List<ValidationEvent> validateOperation(Model model, ServiceShape service, OperationShape operation) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        HttpChecksumTrait trait = operation.expectTrait(HttpChecksumTrait.class);
        List<HttpChecksumProperty> requestProperties = trait.getRequestProperties();
        List<HttpChecksumProperty> responseProperties = trait.getResponseProperties();
        if (requestProperties.isEmpty() && responseProperties.isEmpty()) {
            events.add(this.error(operation, trait, "The `httpChecksum` trait must have at least one of the `request` or `response` properties set."));
        }
        events.addAll(this.validateConflicts(operation, trait, requestProperties, true));
        events.addAll(this.validateConflicts(operation, trait, responseProperties, false));
        for (HttpChecksumProperty property : requestProperties) {
            if (!operation.getInput().isPresent()) {
                events.add(this.error(operation, trait, String.format("Operations modeled with the request properties for `httpChecksum` trait MUST have a modeled input, \"%s\" does not.", operation.getId().getName(service))));
                continue;
            }
            StructureShape inputShape = model.expectShape(operation.getInput().get(), StructureShape.class);
            events.addAll(this.validateName(operation, inputShape, property.getName(), "request"));
        }
        for (HttpChecksumProperty property : responseProperties) {
            if (!operation.getErrors().isEmpty()) {
                for (ShapeId id : operation.getErrors()) {
                    StructureShape shape = model.expectShape(id, StructureShape.class);
                    events.addAll(this.validateName(operation, shape, property.getName(), "response"));
                }
            }
            if (!operation.getOutput().isPresent()) {
                events.add(this.error(operation, trait, String.format("Operations modeled with the response properties for `httpChecksum` trait MUST have a modeled output, \"%s\" does not.", operation.getId().getName(service))));
                continue;
            }
            StructureShape outputShape = model.expectShape(operation.getOutput().get(), StructureShape.class);
            events.addAll(this.validateName(operation, outputShape, property.getName(), "response"));
        }
        return events;
    }

    private List<ValidationEvent> validateConflicts(OperationShape operation, HttpChecksumTrait trait, List<HttpChecksumProperty> properties, boolean isRequestProperties) {
        if (properties.size() <= 1) {
            return Collections.emptyList();
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (int i = 0; i < properties.size(); ++i) {
            for (int j = i + 1; j < properties.size(); ++j) {
                if (!properties.get(i).conflictsWith(properties.get(j))) continue;
                events.add(this.error(operation, trait, String.format("Found conflicting checksum %s properties at indicies %d and %d", isRequestProperties ? "request" : "response", i, j)));
            }
        }
        return events;
    }

    private List<ValidationEvent> validateName(OperationShape operation, StructureShape containerShape, String name, String propertyType) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (MemberShape member : containerShape.members()) {
            member.getTrait(HttpPrefixHeadersTrait.class).ifPresent(httpPrefixHeadersTrait -> {
                String headerPrefix = httpPrefixHeadersTrait.getValue();
                if (name.startsWith(headerPrefix)) {
                    events.add(this.danger(operation, String.format("The `%s` property of the `httpChecksum` trait models name %s that starts with the prefix modeled with the `httpPrefixHeaders` trait on member %s.", propertyType, name, member.getId())));
                }
            });
            member.getTrait(HttpHeaderTrait.class).ifPresent(headerTrait -> {
                String headerName = headerTrait.getValue();
                if (name.equalsIgnoreCase(headerName)) {
                    events.add(this.warning(operation, String.format("The `httpHeader` binding of `%s` on `%s` matches the name `%s` modeled on the `%s` property of `httpChecksum` trait.", headerName, member.getId(), name, propertyType)));
                }
            });
        }
        return events;
    }
}

