/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;

public final class HttpBindingsMissingValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        if (!model.isTraitApplied(HttpTrait.class)) {
            return Collections.emptyList();
        }
        TopDownIndex topDownIndex = model.getKnowledge(TopDownIndex.class);
        return model.shapes(ServiceShape.class).flatMap(shape -> this.validateService(topDownIndex, (ServiceShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(TopDownIndex topDownIndex, ServiceShape service) {
        Set<OperationShape> operations = topDownIndex.getContainedOperations(service);
        if (operations.stream().noneMatch(this::hasBindings)) {
            return ListUtils.of();
        }
        return operations.stream().filter(shape -> !shape.getTrait(HttpTrait.class).isPresent()).map(shape -> this.createEvent(service, (OperationShape)shape)).collect(Collectors.toList());
    }

    private boolean hasBindings(OperationShape op) {
        return op.getTrait(HttpTrait.class).isPresent();
    }

    private ValidationEvent createEvent(ServiceShape service, OperationShape operation) {
        return this.error(operation, String.format("One or more operations in the `%s` service define the `http` trait, but this operation is missing the `http` trait.", service.getId()));
    }
}

