/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.selector.SelectorParser;
import software.amazon.smithy.model.selector.SelectorSyntaxException;
import software.amazon.smithy.model.selector.WrappedSelector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;

public interface Selector {
    public static final Selector IDENTITY = new WrappedSelector("*", ListUtils.of((Object)InternalSelector.IDENTITY));

    public static Selector parse(String expression) {
        return SelectorParser.parse(expression);
    }

    public static Selector fromNode(Node node) {
        try {
            return Selector.parse(node.expectStringNode().getValue());
        }
        catch (SelectorSyntaxException e) {
            throw new SourceException(e.getMessage(), node, e);
        }
    }

    default public Set<Shape> select(Model model) {
        return this.runner().model(model).selectShapes();
    }

    public Runner runner();

    public static final class Runner {
        private final InternalSelector delegate;
        private final Class<? extends Shape> startingShapeType;
        private Model model;

        Runner(InternalSelector delegate, Class<? extends Shape> startingShapeType) {
            this.delegate = delegate;
            this.startingShapeType = startingShapeType;
        }

        public Runner model(Model model) {
            this.model = model;
            return this;
        }

        public Set<Shape> selectShapes() {
            HashSet<Shape> result = new HashSet<Shape>();
            this.pushShapes((ctx, s) -> {
                result.add(s);
                return true;
            });
            return result;
        }

        private Context createContext() {
            SmithyBuilder.requiredState((String)"model", (Object)this.model);
            return new Context(this.model.getKnowledge(NeighborProviderIndex.class));
        }

        public void selectMatches(BiConsumer<Shape, Map<String, Set<Shape>>> matchConsumer) {
            this.pushShapes((ctx, s) -> {
                matchConsumer.accept(s, ctx.copyVars());
                return true;
            });
        }

        private void pushShapes(InternalSelector.Receiver acceptor) {
            Context context = this.createContext();
            if (this.startingShapeType != null) {
                this.model.shapes(this.startingShapeType).forEach(shape -> this.delegate.push(context.clearVars(), (Shape)shape, acceptor));
            } else {
                for (Shape shape2 : this.model.toSet()) {
                    this.delegate.push(context.clearVars(), shape2, acceptor);
                }
            }
        }
    }
}

