/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import software.amazon.smithy.model.loader.IdlModelParser;

final class IdlShapeIdParser {
    private IdlShapeIdParser() {
    }

    static String parseShapeId(IdlModelParser parser) {
        int start = parser.position();
        IdlShapeIdParser.consumeShapeId(parser);
        return parser.sliceFrom(start);
    }

    static String parseIdentifier(IdlModelParser parser) {
        int start = parser.position();
        IdlShapeIdParser.consumeIdentifier(parser);
        return parser.sliceFrom(start);
    }

    static void consumeIdentifier(IdlModelParser parser) {
        if (!IdlShapeIdParser.isIdentifierStart(parser.charPeek())) {
            throw parser.syntax("Expected a valid identifier character, but found '" + parser.peekSingleCharForMessage() + '\'');
        }
        parser.consumeUntilNoLongerMatches(IdlShapeIdParser::isValidIdentifierCharacter);
    }

    private static boolean isValidIdentifierCharacter(char c) {
        return IdlShapeIdParser.isIdentifierStart(c) || IdlShapeIdParser.isDigit(c);
    }

    static String parseNamespace(IdlModelParser parser) {
        int start = parser.position();
        IdlShapeIdParser.consumeNamespace(parser);
        return parser.sliceFrom(start);
    }

    static boolean isIdentifierStart(char c) {
        return c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static void consumeNamespace(IdlModelParser parser) {
        IdlShapeIdParser.consumeIdentifier(parser);
        while (parser.charPeek() == '.') {
            parser.skip();
            IdlShapeIdParser.consumeIdentifier(parser);
        }
    }

    private static void consumeShapeId(IdlModelParser parser) {
        IdlShapeIdParser.consumeNamespace(parser);
        if (parser.charPeek() == '#') {
            parser.skip();
            IdlShapeIdParser.consumeIdentifier(parser);
        }
        if (parser.charPeek() == '$') {
            parser.skip();
            IdlShapeIdParser.consumeIdentifier(parser);
        }
    }
}

