/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.linters;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;

public final class EmitEachSelectorValidator
extends AbstractValidator {
    private final Config config;

    private EmitEachSelectorValidator(Config config) {
        this.config = config;
        Objects.requireNonNull(config.selector, "selector is required");
    }

    @Override
    public List<ValidationEvent> validate(Model model) {
        return this.config.getSelector().select(model).stream().map(shape -> this.danger((Shape)shape, "Selector capture matched selector: " + this.config.getSelector())).collect(Collectors.toList());
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(EmitEachSelectorValidator.class, (ObjectNode configuration) -> {
                NodeMapper mapper = new NodeMapper();
                Config config = mapper.deserialize((Node)configuration, Config.class);
                return new EmitEachSelectorValidator(config);
            });
        }
    }

    public static final class Config {
        private Selector selector;

        public Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Selector selector) {
            this.selector = selector;
        }
    }
}

