/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class AuthDefinitionTrait
extends AbstractTrait
implements ToSmithyBuilder<AuthDefinitionTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#authDefinition");
    private final List<ShapeId> traits;

    public AuthDefinitionTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
        this.traits = ListUtils.copyOf((Collection)builder.traits);
    }

    public List<ShapeId> getTraits() {
        return this.traits;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Node createNode() {
        if (this.traits.isEmpty()) {
            return Node.objectNode();
        }
        ArrayNode ids = this.traits.stream().map(ShapeId::toString).map(Node::from).collect(ArrayNode.collect());
        return Node.objectNode().withMember("traits", ids);
    }

    public Builder toBuilder() {
        return ((Builder)AuthDefinitionTrait.builder().sourceLocation(this.getSourceLocation())).traits(this.traits);
    }

    public static final class Builder
    extends AbstractTraitBuilder<AuthDefinitionTrait, Builder> {
        private final List<ShapeId> traits = new ArrayList<ShapeId>();

        public AuthDefinitionTrait build() {
            return new AuthDefinitionTrait(this);
        }

        public Builder traits(List<ShapeId> traits) {
            this.traits.clear();
            this.traits.addAll(traits);
            return this;
        }

        public Builder addTrait(ShapeId trait) {
            this.traits.add(trait);
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public AuthDefinitionTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)AuthDefinitionTrait.builder().sourceLocation(value);
            ObjectNode objectNode = value.expectObjectNode();
            objectNode.getArrayMember("traits").ifPresent(traits -> {
                for (String string : Node.loadArrayOfString("traits", traits)) {
                    builder.addTrait(ShapeId.from(string));
                }
            });
            return builder.build();
        }
    }
}

