/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIdSyntaxException;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Suppression
implements FromSourceLocation,
ToSmithyBuilder<Suppression> {
    private final SourceLocation sourceLocation;
    private final String reason;
    private final Set<ShapeId> shapes;
    private final Set<String> validatorIds;
    private final Set<String> namespaceNames;
    private Predicate<ValidationEvent> predicate;

    private Suppression(Builder builder) {
        if (builder.validatorIds.isEmpty()) {
            throw new SourceException("Suppressions require at least one `id`", builder.sourceLocation);
        }
        builder.validatorIds.forEach(id -> {
            if (id.isEmpty()) {
                throw new SourceException("Suppression `ids` element must not be empty", builder.sourceLocation);
            }
            if (id.indexOf(42) > 0) {
                throw new SourceException(String.format("Invalid suppression `ids` wildcard: `%s`", id), builder.sourceLocation);
            }
        });
        this.validatorIds = Collections.unmodifiableSet(new LinkedHashSet(builder.validatorIds));
        LinkedHashSet shapeIds = new LinkedHashSet();
        builder.shapes.forEach(shape -> {
            try {
                shapeIds.add(ShapeId.from(shape));
            }
            catch (ShapeIdSyntaxException e) {
                throw new SourceException(e.getMessage(), builder.sourceLocation);
            }
        });
        this.shapes = Collections.unmodifiableSet(shapeIds);
        this.sourceLocation = builder.sourceLocation;
        this.reason = builder.reason;
        this.namespaceNames = new HashSet<String>(builder.namespaceNames);
        this.predicate = Suppression.createPredicate(this.validatorIds, this.shapes, this.namespaceNames);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = Suppression.builder().sourceLocation(this.sourceLocation).reason(this.reason);
        this.namespaceNames.forEach(builder::addShape);
        this.shapes.forEach(builder::addShape);
        this.validatorIds.forEach(builder::addValidatorId);
        return builder;
    }

    public static ValidationEvent suppressEvent(ValidationEvent validationEvent, List<Suppression> suppressions) {
        Iterator<Suppression> suppressionIterator = suppressions.iterator();
        while (validationEvent.getSeverity().canSuppress() && suppressionIterator.hasNext()) {
            validationEvent = suppressionIterator.next().suppress(validationEvent);
        }
        return validationEvent;
    }

    private static Predicate<ValidationEvent> createPredicate(Set<String> eventIds, Set<ShapeId> shapeIds, Set<String> namespaceNames) {
        ArrayList<Predicate<ValidationEvent>> predicates = new ArrayList<Predicate<ValidationEvent>>();
        predicates.add(event -> event.getSeverity().canSuppress());
        eventIds.stream().filter(rule -> !rule.equals("*")).forEach(rule -> predicates.add(event -> event.getEventId().equals(rule)));
        if (!shapeIds.isEmpty() || !namespaceNames.isEmpty()) {
            predicates.add(event -> event.getShapeId().filter(id -> namespaceNames.contains(id.getNamespace()) || shapeIds.contains(id)).isPresent());
        }
        return event -> predicates.stream().allMatch(p -> p.test(event));
    }

    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }

    public Set<String> getValidatorIds() {
        return this.validatorIds;
    }

    public Set<ShapeId> getShapes() {
        return this.shapes;
    }

    public Set<String> getNamespaceNames() {
        return this.namespaceNames;
    }

    public ValidationEvent suppress(ValidationEvent event) {
        if (!this.predicate.test(event)) {
            return event;
        }
        ValidationEvent.Builder builder = event.toBuilder().severity(Severity.SUPPRESSED);
        if (this.reason != null) {
            builder.suppressionReason(this.reason);
        }
        return builder.build();
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public String toString() {
        return "suppression of `" + this.validatorIds.stream().collect(Collectors.joining("`, `")) + "`";
    }

    public static final class Builder
    implements SmithyBuilder<Suppression> {
        private SourceLocation sourceLocation = SourceLocation.none();
        private String reason;
        private final Set<String> shapes = new LinkedHashSet<String>();
        private final Set<String> validatorIds = new LinkedHashSet<String>();
        private final Set<String> namespaceNames = new HashSet<String>();

        private Builder() {
        }

        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = Objects.requireNonNull(sourceLocation);
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder addShape(String shapeId) {
            Objects.requireNonNull(shapeId, "shapeId must not be null");
            if (shapeId.endsWith("#")) {
                this.namespaceNames.add(shapeId.substring(0, shapeId.length() - 1));
            } else {
                this.shapes.add(shapeId);
            }
            return this;
        }

        public Builder addShape(ShapeId shapeId) {
            this.shapes.add(Objects.requireNonNull(shapeId.toString(), "shapeId must not be null"));
            return this;
        }

        public Builder addValidatorId(String id) {
            this.validatorIds.add(Objects.requireNonNull(id, "validatorId must not be null"));
            return this;
        }

        public Suppression build() {
            return new Suppression(this);
        }
    }
}

