/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.utils.OptionalUtils;

public final class Walker {
    private final NeighborProvider provider;

    public Walker(Model model) {
        this(model.getKnowledge(NeighborProviderIndex.class).getProvider());
    }

    public Walker(NeighborProvider provider) {
        this.provider = provider;
    }

    @Deprecated
    public Walker(ShapeIndex shapeIndex) {
        this(NeighborProvider.of(shapeIndex));
    }

    public Set<Shape> walkShapes(Shape shape) {
        return this.walkShapes(shape, rel -> true);
    }

    public Set<Shape> walkShapes(Shape shape, Predicate<Relationship> predicate) {
        Set<Shape> connectedShapes = this.walk(shape, predicate).stream().flatMap(rel -> OptionalUtils.stream(rel.getNeighborShape())).collect(Collectors.toSet());
        connectedShapes.add(shape);
        return connectedShapes;
    }

    private List<Relationship> walk(Shape shape, Predicate<Relationship> predicate) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        HashSet<ShapeId> traversed = new HashSet<ShapeId>();
        traversed.add(shape.getId());
        Stack<Relationship> stack = new Stack<Relationship>();
        this.pushNeighbors(stack, predicate, this.provider.getNeighbors(shape));
        while (!stack.isEmpty()) {
            Relationship relationship = stack.pop();
            relationship.getNeighborShape().ifPresent(neighbor -> {
                if (!traversed.contains(neighbor.getId())) {
                    traversed.add(neighbor.getId());
                    this.pushNeighbors(stack, predicate, this.provider.getNeighbors((Shape)neighbor));
                }
            });
            relationships.add(relationship);
        }
        return relationships;
    }

    private void pushNeighbors(Stack<Relationship> stack, Predicate<Relationship> predicate, Collection<Relationship> relationships) {
        relationships.stream().filter(predicate).forEach(stack::push);
    }
}

