/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.loader.LoaderVisitor;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.ListUtils;

final class LoaderUtils {
    private static final String PUT_KEY = "put";
    private static final String CREATE_KEY = "create";
    private static final String READ_KEY = "read";
    private static final String UPDATE_KEY = "update";
    private static final String DELETE_KEY = "delete";
    private static final String LIST_KEY = "list";
    private static final String RESOURCES_KEY = "resources";
    private static final String OPERATIONS_KEY = "operations";
    private static final String COLLECTION_OPERATIONS_KEY = "collectionOperations";
    private static final String IDENTIFIERS_KEY = "identifiers";
    private static final String TYPE_KEY = "type";
    private static final String VERSION_KEY = "version";
    static final Collection<String> RESOURCE_PROPERTY_NAMES = ListUtils.of((Object[])new String[]{"type", "create", "read", "update", "delete", "list", "identifiers", "resources", "operations", "put", "collectionOperations"});
    static final List<String> SERVICE_PROPERTY_NAMES = ListUtils.of((Object[])new String[]{"type", "version", "operations", "resources"});

    private LoaderUtils() {
    }

    static void loadServiceObject(ServiceShape.Builder builder, ShapeId shapeId, ObjectNode shapeNode) {
        builder.version(shapeNode.expectStringMember(VERSION_KEY).getValue());
        LoaderUtils.optionalIdList(shapeNode, shapeId.getNamespace(), OPERATIONS_KEY).forEach(builder::addOperation);
        LoaderUtils.optionalIdList(shapeNode, shapeId.getNamespace(), RESOURCES_KEY).forEach(builder::addResource);
    }

    static void loadResourceObject(ResourceShape.Builder builder, ShapeId shapeId, ObjectNode shapeNode, LoaderVisitor visitor) {
        LoaderUtils.optionalId(shapeNode, shapeId.getNamespace(), PUT_KEY).ifPresent(builder::put);
        LoaderUtils.optionalId(shapeNode, shapeId.getNamespace(), CREATE_KEY).ifPresent(builder::create);
        LoaderUtils.optionalId(shapeNode, shapeId.getNamespace(), READ_KEY).ifPresent(builder::read);
        LoaderUtils.optionalId(shapeNode, shapeId.getNamespace(), UPDATE_KEY).ifPresent(builder::update);
        LoaderUtils.optionalId(shapeNode, shapeId.getNamespace(), DELETE_KEY).ifPresent(builder::delete);
        LoaderUtils.optionalId(shapeNode, shapeId.getNamespace(), LIST_KEY).ifPresent(builder::list);
        LoaderUtils.optionalIdList(shapeNode, shapeId.getNamespace(), OPERATIONS_KEY).forEach(builder::addOperation);
        LoaderUtils.optionalIdList(shapeNode, shapeId.getNamespace(), RESOURCES_KEY).forEach(builder::addResource);
        LoaderUtils.optionalIdList(shapeNode, shapeId.getNamespace(), COLLECTION_OPERATIONS_KEY).forEach(builder::addCollectionOperation);
        shapeNode.getObjectMember(IDENTIFIERS_KEY).ifPresent(ids -> {
            for (Map.Entry<StringNode, Node> entry : ids.getMembers().entrySet()) {
                String name = entry.getKey().getValue();
                StringNode target = entry.getValue().expectStringNode();
                visitor.onShapeTarget(target.getValue(), target, id -> builder.addIdentifier(name, (ToShapeId)id));
            }
        });
    }

    static Optional<ShapeId> optionalId(ObjectNode node, String namespace, String name) {
        return node.getStringMember(name).map(stringNode -> stringNode.expectShapeId(namespace));
    }

    static List<ShapeId> optionalIdList(ObjectNode node, String namespace, String name) {
        return node.getArrayMember(name).map(array -> array.getElements().stream().map(Node::expectStringNode).map(s -> s.expectShapeId(namespace)).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }
}

