/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.OptionalUtils;

public class ExclusiveStructureMemberTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.shapes(StructureShape.class).flatMap(shape -> this.validateExclusiveTraits(model, (StructureShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateExclusiveTraits(Model model, StructureShape shape) {
        return shape.getAllMembers().values().stream().flatMap(member -> member.getAllTraits().values().stream()).filter(trait -> this.isExclusive(model, (Trait)trait)).flatMap(t -> OptionalUtils.stream(this.validateExclusiveTrait(shape, t.toShapeId()))).collect(Collectors.toList());
    }

    private boolean isExclusive(Model model, Trait trait) {
        return model.getTraitDefinition(trait).map(TraitDefinition::isStructurallyExclusive).orElse(false);
    }

    private Optional<ValidationEvent> validateExclusiveTrait(StructureShape shape, ShapeId traitName) {
        List matches = shape.getAllMembers().values().stream().filter(member -> member.findTrait(traitName).isPresent()).map(MemberShape::getMemberName).collect(Collectors.toList());
        if (matches.size() > 1) {
            return Optional.of(this.error(shape, String.format("The `%s` trait can be applied to only a single member of a structure, but was found on the following members: %s", Trait.getIdiomaticTraitName(traitName), ValidationUtils.tickedList(matches))));
        }
        return Optional.empty();
    }
}

