/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class StreamingTrait
extends AbstractTrait
implements ToSmithyBuilder<StreamingTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#streaming");
    private static final String REQUIRES_LENGTH = "requiresLength";
    private final boolean requiresLength;

    private StreamingTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
        this.requiresLength = builder.requiresLength;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean getRequiresLength() {
        return this.requiresLength;
    }

    public Builder toBuilder() {
        return StreamingTrait.builder().requiresLength(this.requiresLength);
    }

    @Override
    protected Node createNode() {
        return this.requiresLength ? Node.objectNode().withMember(REQUIRES_LENGTH, true) : Node.objectNode();
    }

    public static final class Builder
    extends AbstractTraitBuilder<StreamingTrait, Builder> {
        private boolean requiresLength;

        private Builder() {
        }

        public StreamingTrait build() {
            return new StreamingTrait(this);
        }

        public Builder requiresLength(boolean requiresLength) {
            this.requiresLength = requiresLength;
            return this;
        }
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public StreamingTrait createTrait(ShapeId target, Node value) {
            ObjectNode node = value.expectObjectNode();
            return StreamingTrait.builder().requiresLength(node.getBooleanMemberOrDefault(StreamingTrait.REQUIRES_LENGTH)).build();
        }
    }
}

