/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.XmlNamespaceTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;

public class XmlNamespaceTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.shapes(StructureShape.class).flatMap(shape -> Trait.flatMapStream(shape, XmlNamespaceTrait.class)).flatMap(pair -> OptionalUtils.stream(this.validateTrait((Shape)pair.getLeft(), (XmlNamespaceTrait)pair.getRight()))).collect(Collectors.toList());
    }

    private Optional<ValidationEvent> validateTrait(Shape shape, XmlNamespaceTrait xmlNamespace) {
        try {
            new URI(xmlNamespace.getUri());
        }
        catch (URISyntaxException uriSyntaxException) {
            return Optional.of(this.error(shape, String.format("An `xmlNamespace` trait is applied to the %s shape with an invalid uri: %s", shape, xmlNamespace.getUri())));
        }
        return Optional.empty();
    }
}

