/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.EventStreamInfo;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.EventStreamTrait;

public final class EventStreamIndex
implements KnowledgeIndex {
    private static final Logger LOGGER = Logger.getLogger(EventStreamIndex.class.getName());
    private final Map<ShapeId, EventStreamInfo> inputInfo = new HashMap<ShapeId, EventStreamInfo>();
    private final Map<ShapeId, EventStreamInfo> outputInfo = new HashMap<ShapeId, EventStreamInfo>();

    public EventStreamIndex(Model model) {
        ShapeIndex index = model.getShapeIndex();
        OperationIndex operationIndex = model.getKnowledge(OperationIndex.class);
        model.getShapeIndex().shapes(OperationShape.class).forEach(operation -> {
            operationIndex.getInput((ToShapeId)operation).ifPresent(input -> this.computeEvents(index, (OperationShape)operation, (StructureShape)input, this.inputInfo));
            operationIndex.getOutput((ToShapeId)operation).ifPresent(output -> this.computeEvents(index, (OperationShape)operation, (StructureShape)output, this.outputInfo));
        });
    }

    private void computeEvents(ShapeIndex index, OperationShape operation, StructureShape shape, Map<ShapeId, EventStreamInfo> infoMap) {
        for (MemberShape member : shape.getAllMembers().values()) {
            if (!member.hasTrait(EventStreamTrait.class)) continue;
            this.createEventStreamInfo(index, operation, shape, member).ifPresent(info -> infoMap.put(operation.getId(), (EventStreamInfo)info));
        }
    }

    public Optional<EventStreamInfo> getInputInfo(ToShapeId operationShape) {
        return Optional.ofNullable(this.inputInfo.get(operationShape.toShapeId()));
    }

    public Optional<EventStreamInfo> getOutputInfo(ToShapeId operationShape) {
        return Optional.ofNullable(this.outputInfo.get(operationShape.toShapeId()));
    }

    private Optional<EventStreamInfo> createEventStreamInfo(ShapeIndex index, OperationShape operation, StructureShape structure, MemberShape member) {
        EventStreamTrait trait = member.getTrait(EventStreamTrait.class).get();
        Shape eventStreamTarget = index.getShape(member.getTarget()).orElse(null);
        if (eventStreamTarget == null) {
            LOGGER.severe(String.format("Skipping event stream info for %s because the %s member target %s does not exist", operation.getId(), member.getMemberName(), member.getTarget()));
            return Optional.empty();
        }
        HashMap<String, StructureShape> events = new HashMap<String, StructureShape>();
        if (eventStreamTarget.asUnionShape().isPresent()) {
            for (MemberShape unionMember : eventStreamTarget.asUnionShape().get().getAllMembers().values()) {
                index.getShape(unionMember.getTarget()).flatMap(Shape::asStructureShape).ifPresent(struct -> events.put(unionMember.getMemberName(), (StructureShape)struct));
            }
        } else if (eventStreamTarget.asStructureShape().isPresent()) {
            events.put(member.getMemberName(), eventStreamTarget.asStructureShape().get());
        } else {
            LOGGER.severe(() -> String.format("Skipping event stream info for %s because the %s member target %s is not a structure or union", operation.getId(), member.getMemberName(), member.getTarget()));
            return Optional.empty();
        }
        HashMap<String, MemberShape> initialMembers = new HashMap<String, MemberShape>();
        HashMap<String, Shape> initialTargets = new HashMap<String, Shape>();
        for (MemberShape structureMember : structure.getAllMembers().values()) {
            if (structureMember.getMemberName().equals(member.getMemberName())) continue;
            index.getShape(structureMember.getTarget()).ifPresent(shapeTarget -> {
                initialMembers.put(structureMember.getMemberName(), structureMember);
                initialTargets.put(structureMember.getMemberName(), (Shape)shapeTarget);
            });
        }
        return Optional.of(new EventStreamInfo(operation, trait, structure, member, eventStreamTarget, initialMembers, initialTargets, events));
    }
}

