/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.node.FilteredPlugin;

public final class StringEnumPlugin
extends FilteredPlugin<StringShape, StringNode> {
    public StringEnumPlugin() {
        super(StringShape.class, StringNode.class);
    }

    @Override
    protected List<String> check(StringShape shape, StringNode node, ShapeIndex index) {
        ArrayList<String> messages = new ArrayList<String>();
        shape.getTrait(EnumTrait.class).ifPresent(trait -> {
            if (!trait.getValues().containsKey(node.getValue())) {
                messages.add(String.format("String value provided for `%s` must be one of the following values: %s", shape.getId(), ValidationUtils.tickedList(trait.getValues().keySet())));
            }
        });
        return messages;
    }
}

