/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;

public final class BlobLengthPlugin
extends MemberAndShapeTraitPlugin<BlobShape, StringNode, LengthTrait> {
    public BlobLengthPlugin() {
        super(BlobShape.class, StringNode.class, LengthTrait.class);
    }

    @Override
    protected List<String> check(Shape shape, LengthTrait trait, StringNode node, ShapeIndex index) {
        String value = node.getValue();
        ArrayList<String> messages = new ArrayList<String>();
        int size = value.getBytes(Charset.forName("UTF-8")).length;
        trait.getMin().ifPresent(min -> {
            if ((long)size < min) {
                messages.add("Value provided for `" + shape.getId() + "` must have at least " + min + " bytes, but the provided value only has " + size + " bytes");
            }
        });
        trait.getMax().ifPresent(max -> {
            if ((long)value.getBytes(Charset.forName("UTF-8")).length > max) {
                messages.add("Value provided for `" + shape.getId() + "` must have no more than " + max + " bytes, but the provided value has " + size + " bytes");
            }
        });
        return messages;
    }
}

