/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Objects;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.SmithyBuilder;

public abstract class CollectionShape
extends Shape {
    private final MemberShape member;

    CollectionShape(Builder builder) {
        super(builder, false);
        this.member = (MemberShape)SmithyBuilder.requiredState((String)"member", (Object)builder.member);
        ShapeId expected = this.getId().withMember("member");
        if (!this.member.getId().equals(expected)) {
            throw new IllegalArgumentException(String.format("Expected member of `%s` to have an ID of `%s` but found `%s`", this.getId(), expected, this.member.getId()));
        }
    }

    public final MemberShape getMember() {
        return this.member;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.getMember().equals(((CollectionShape)other).getMember());
    }

    public static abstract class Builder<B extends Builder, S extends CollectionShape>
    extends AbstractShapeBuilder<B, S> {
        private MemberShape member;

        public B member(MemberShape member) {
            this.member = Objects.requireNonNull(member);
            return (B)this;
        }

        @Override
        public final B addMember(MemberShape member) {
            return this.member(member);
        }
    }
}

