/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.Objects;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.loader.ValidatorDefinition;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.model.validation.ValidatorFactory;
import software.amazon.smithy.utils.ListUtils;

final class ValidatorFromDefinitionFactory {
    private final ValidatorFactory delegate;

    ValidatorFromDefinitionFactory(ValidatorFactory delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate validator must not be null");
    }

    ValidatedResult<Validator> loadValidator(ValidatorDefinition definition) {
        try {
            return this.delegate.createValidator(definition.name, definition.configuration).map(validator -> ValidatedResult.fromValue(this.mapValidator(definition, (Validator)validator))).orElseGet(ValidatedResult::empty);
        }
        catch (SourceException e) {
            return ValidatedResult.fromErrors(ListUtils.of((Object)ValidationEvent.fromSourceException(e, String.format("Error creating `%s` validator: ", definition.name))));
        }
    }

    private Validator mapValidator(ValidatorDefinition definition, Validator upstream) {
        return model -> definition.map(model, upstream.validate(model));
    }
}

