/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.pattern.UriPattern;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public final class HttpUriConflictValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        TopDownIndex topDownIndex = model.getKnowledge(TopDownIndex.class);
        return model.getShapeIndex().shapes(ServiceShape.class).flatMap(shape -> this.validateService(topDownIndex, (ServiceShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(TopDownIndex topDownIndex, ServiceShape service) {
        List operations = topDownIndex.getContainedOperations(service).stream().filter(shape -> shape.getTrait(HttpTrait.class).isPresent()).collect(Collectors.toList());
        return operations.stream().flatMap(shape -> Trait.flatMapStream(shape, HttpTrait.class)).flatMap(pair -> OptionalUtils.stream(this.checkConflicts((Pair<OperationShape, HttpTrait>)pair, operations))).collect(Collectors.toList());
    }

    private Optional<ValidationEvent> checkConflicts(Pair<OperationShape, HttpTrait> pair, List<OperationShape> operations) {
        OperationShape operation = (OperationShape)pair.getLeft();
        String method = ((HttpTrait)pair.getRight()).getMethod();
        UriPattern pattern = ((HttpTrait)pair.getRight()).getUri();
        String conflicts = operations.stream().filter(shape -> shape != operation).flatMap(shape -> Trait.flatMapStream(shape, HttpTrait.class)).filter(other -> ((HttpTrait)other.getRight()).getMethod().equals(method)).filter(other -> ((HttpTrait)other.getRight()).getUri().conflictsWith(pattern)).map(other -> String.format("`%s` (%s)", ((OperationShape)other.getLeft()).getId(), ((HttpTrait)other.getRight()).getUri())).sorted().collect(Collectors.joining(", "));
        if (conflicts.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.error(operation, String.format("Operation URI, `%s`, conflicts with other operation URIs in the same service: [%s]", pattern, conflicts)));
    }
}

