/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.EventHeaderTrait;
import software.amazon.smithy.model.traits.EventPayloadTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.FunctionalUtils;

public class EventPayloadTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.getShapeIndex().shapes(StructureShape.class).flatMap(this::validateEvent).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateEvent(StructureShape shape) {
        List unmarked = shape.getAllMembers().values().stream().filter(FunctionalUtils.not(this::isMarked)).map(MemberShape::getMemberName).collect(Collectors.toList());
        boolean payloads = shape.getAllMembers().values().stream().anyMatch(value -> value.getTrait(EventPayloadTrait.class).isPresent());
        if (unmarked.isEmpty() || !payloads) {
            return Stream.empty();
        }
        return Stream.of(this.error(shape, String.format("This event structure contains a member marked with the `eventPayload` trait, so all other members must be marked with the `eventHeader` trait. However, the following member(s) are not marked with the eventHeader trait: %s", ValidationUtils.tickedList(unmarked))));
    }

    private boolean isMarked(Shape s) {
        return s.getTrait(EventHeaderTrait.class).isPresent() || s.getTrait(EventPayloadTrait.class).isPresent();
    }
}

