/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.traits.Protocol;
import software.amazon.smithy.model.traits.ProtocolsTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.OptionalUtils;

public final class AuthValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        TopDownIndex topDownIndex = model.getKnowledge(TopDownIndex.class);
        return model.getShapeIndex().shapes(ServiceShape.class).flatMap(service -> this.validateService(topDownIndex, (ServiceShape)service).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(TopDownIndex topDownIndex, ServiceShape service) {
        Optional<ProtocolsTrait> protocols = service.getTrait(ProtocolsTrait.class);
        if (!protocols.isPresent()) {
            return ListUtils.of();
        }
        ArrayList<ValidationEvent> result = new ArrayList<ValidationEvent>();
        OptionalUtils.stream(service.getTrait(AuthTrait.class)).flatMap(trait -> OptionalUtils.stream(this.validateSchemes((ProtocolsTrait)protocols.get(), service, service, (AuthTrait)trait))).forEach(result::add);
        topDownIndex.getContainedOperations(service).stream().flatMap(operation -> OptionalUtils.stream(operation.getTrait(AuthTrait.class)).flatMap(trait -> OptionalUtils.stream(this.validateSchemes((ProtocolsTrait)protocols.get(), service, (Shape)operation, (AuthTrait)trait)))).forEach(result::add);
        this.validateUniqueNames(service, protocols.get()).ifPresent(result::add);
        return result;
    }

    private Optional<ValidationEvent> validateSchemes(ProtocolsTrait protocols, ServiceShape service, Shape shape, AuthTrait trait) {
        Set<String> serviceSchemes = protocols.getAllAuthSchemes();
        HashSet<String> copiedSchemes = new HashSet<String>(trait.getValues());
        copiedSchemes.removeAll(serviceSchemes);
        copiedSchemes.remove("none");
        if (copiedSchemes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.error(shape, trait, String.format("The following `auth` trait values are not compatible with the `auth` schemes listed in the `protocols` trait of the service, `%s`: [%s]. This service supports the following authentication schemes: [%s]", service.getId(), ValidationUtils.tickedList(copiedSchemes), ValidationUtils.tickedList(serviceSchemes))));
    }

    private Optional<ValidationEvent> validateUniqueNames(ServiceShape shape, ProtocolsTrait protocols) {
        List result = protocols.getProtocols().stream().collect(Collectors.groupingBy(Protocol::getName)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.error(shape, protocols, String.format("`protocols` trait contains conflicting protocol names: %s", result)));
    }
}

