/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.EventStreamInfo;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.InputEventStreamTrait;
import software.amazon.smithy.model.traits.OutputEventStreamTrait;
import software.amazon.smithy.model.traits.StringTrait;

public final class EventStreamIndex
implements KnowledgeIndex {
    private static final Logger LOGGER = Logger.getLogger(EventStreamIndex.class.getName());
    private final Map<ShapeId, EventStreamInfo> inputInfo = new HashMap<ShapeId, EventStreamInfo>();
    private final Map<ShapeId, EventStreamInfo> outputInfo = new HashMap<ShapeId, EventStreamInfo>();

    public EventStreamIndex(Model model) {
        ShapeIndex index = model.getShapeIndex();
        OperationIndex operationIndex = model.getKnowledge(OperationIndex.class);
        model.getShapeIndex().shapes(OperationShape.class).forEach(operation -> {
            operation.getTrait(InputEventStreamTrait.class).ifPresent(trait -> operationIndex.getInput((ToShapeId)operation).flatMap(input -> this.createEventStreamInfo(index, (OperationShape)operation, (StructureShape)input, (StringTrait)trait)).ifPresent(info -> this.inputInfo.put(operation.getId(), (EventStreamInfo)info)));
            operation.getTrait(OutputEventStreamTrait.class).ifPresent(trait -> operationIndex.getOutput((ToShapeId)operation).flatMap(output -> this.createEventStreamInfo(index, (OperationShape)operation, (StructureShape)output, (StringTrait)trait)).ifPresent(info -> this.outputInfo.put(operation.getId(), (EventStreamInfo)info)));
        });
    }

    public Optional<EventStreamInfo> getInputInfo(ToShapeId operationShape) {
        return Optional.ofNullable(this.inputInfo.get(operationShape.toShapeId()));
    }

    public Optional<EventStreamInfo> getOutputInfo(ToShapeId operationShape) {
        return Optional.ofNullable(this.outputInfo.get(operationShape.toShapeId()));
    }

    private Optional<EventStreamInfo> createEventStreamInfo(ShapeIndex index, OperationShape operation, StructureShape structure, StringTrait trait) {
        String eventStreamMemberName = trait.getValue();
        MemberShape eventStreamMember = structure.getMember(eventStreamMemberName).orElse(null);
        if (eventStreamMember == null) {
            LOGGER.severe(() -> String.format("Skipping event stream info for %s because the member %s does not exist", operation.getId(), eventStreamMemberName));
            return Optional.empty();
        }
        Shape eventStreamTarget = index.getShape(eventStreamMember.getTarget()).orElse(null);
        if (eventStreamTarget == null) {
            LOGGER.severe(String.format("Skipping event stream info for %s because the %s member target %s does not exist", operation.getId(), eventStreamMemberName, eventStreamMember.getTarget()));
            return Optional.empty();
        }
        HashMap<String, StructureShape> events = new HashMap<String, StructureShape>();
        if (eventStreamTarget.asUnionShape().isPresent()) {
            for (MemberShape member : eventStreamTarget.asUnionShape().get().getAllMembers().values()) {
                index.getShape(member.getTarget()).flatMap(Shape::asStructureShape).ifPresent(struct -> events.put(member.getMemberName(), (StructureShape)struct));
            }
        } else if (eventStreamTarget.asStructureShape().isPresent()) {
            events.put(trait.getValue(), eventStreamTarget.asStructureShape().get());
        } else {
            LOGGER.severe(() -> String.format("Skipping event stream info for %s because the %s member target %s is not a structure or union", operation.getId(), eventStreamMemberName, eventStreamMember.getTarget()));
            return Optional.empty();
        }
        HashMap<String, MemberShape> initialMembers = new HashMap<String, MemberShape>();
        HashMap<String, Shape> initialTargets = new HashMap<String, Shape>();
        for (MemberShape member : structure.getAllMembers().values()) {
            if (member.getMemberName().equals(eventStreamMemberName)) continue;
            index.getShape(member.getTarget()).ifPresent(shapeTarget -> {
                initialMembers.put(member.getMemberName(), member);
                initialTargets.put(member.getMemberName(), (Shape)shapeTarget);
            });
        }
        return Optional.of(new EventStreamInfo(operation, trait, structure, eventStreamMember, eventStreamTarget, initialMembers, initialTargets, events));
    }
}

