/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.PaginatedTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.SetUtils;

public final class PaginatedTraitValidator
extends AbstractValidator {
    private static final Set<ShapeType> ITEM_SHAPES = SetUtils.of((Object[])new ShapeType[]{ShapeType.LIST, ShapeType.MAP});
    private static final Set<ShapeType> PAGE_SHAPES = SetUtils.of((Object)((Object)ShapeType.INTEGER));
    private static final Set<ShapeType> STRING_SET = SetUtils.of((Object)((Object)ShapeType.STRING));

    @Override
    public List<ValidationEvent> validate(Model model) {
        ShapeIndex shapeIndex = model.getShapeIndex();
        OperationIndex opIndex = model.getKnowledge(OperationIndex.class);
        TopDownIndex topDown = model.getKnowledge(TopDownIndex.class);
        return shapeIndex.shapes(OperationShape.class).flatMap(shape -> Trait.flatMapStream(shape, PaginatedTrait.class)).flatMap(pair -> this.validateOperation(shapeIndex, topDown, opIndex, (OperationShape)pair.left, (PaginatedTrait)pair.right).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateOperation(ShapeIndex index, TopDownIndex topDownIndex, OperationIndex opIndex, OperationShape operation, PaginatedTrait trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (!opIndex.getInput(operation).isPresent()) {
            events.add(this.error(operation, trait, "paginated operations require an input"));
        } else {
            events.addAll(this.validateMember(opIndex, index, null, operation, trait, new InputTokenValidator()));
            events.addAll(this.validateMember(opIndex, index, null, operation, trait, new PageSizeValidator()));
        }
        if (!opIndex.getOutput(operation).isPresent()) {
            events.add(this.error(operation, trait, "paginated operations require an output"));
        } else {
            events.addAll(this.validateMember(opIndex, index, null, operation, trait, new OutputTokenValidator()));
            events.addAll(this.validateMember(opIndex, index, null, operation, trait, new ItemValidator()));
        }
        if (events.isEmpty()) {
            index.shapes(ServiceShape.class).forEach(svc -> {
                if (topDownIndex.getContainedOperations((ToShapeId)svc).contains(operation)) {
                    PaginatedTrait merged = svc.getTrait(PaginatedTrait.class).map(trait::merge).orElse(trait);
                    events.addAll(this.validateMember(opIndex, index, (ServiceShape)svc, operation, merged, new InputTokenValidator()));
                    events.addAll(this.validateMember(opIndex, index, (ServiceShape)svc, operation, merged, new PageSizeValidator()));
                    events.addAll(this.validateMember(opIndex, index, (ServiceShape)svc, operation, merged, new OutputTokenValidator()));
                    events.addAll(this.validateMember(opIndex, index, (ServiceShape)svc, operation, merged, new ItemValidator()));
                }
            });
        }
        return events;
    }

    private List<ValidationEvent> validateMember(OperationIndex opIndex, ShapeIndex index, ServiceShape service, OperationShape operation, PaginatedTrait trait, PropertyValidator validator) {
        Shape target;
        String prefix = service != null ? "When bound within the `" + service.getId() + "` service, " : "";
        String memberName = validator.getMemberName(opIndex, operation, trait).orElse(null);
        if (memberName == null) {
            return service != null && validator.isRequiredToBePresent() ? Collections.singletonList(this.error(operation, trait, String.format("%spaginated trait `%s` is not configured", prefix, validator.propertyName()))) : Collections.emptyList();
        }
        MemberShape member = validator.getMember(opIndex, operation, trait).orElse(null);
        if (member == null) {
            return Collections.singletonList(this.error(operation, trait, String.format("%spaginated trait `%s` targets a member `%s` that does not exist", prefix, validator.propertyName(), memberName)));
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (validator.mustBeOptional() && member.isRequired()) {
            events.add(this.error(operation, trait, String.format("%spaginated trait `%s` member `%s` must not be required", prefix, validator.propertyName(), member.getMemberName())));
        }
        if ((target = (Shape)index.getShape(member.getTarget()).orElse(null)) != null && !validator.validTargets().contains((Object)target.getType())) {
            events.add(this.error(operation, trait, String.format("%spaginated trait `%s` member `%s` targets a %s shape, but must target one of the following: [%s]", new Object[]{prefix, validator.propertyName(), member.getId().getName(), target.getType(), ValidationUtils.tickedList(validator.validTargets())})));
        }
        return events;
    }

    private static final class ItemValidator
    extends PropertyValidator {
        private ItemValidator() {
        }

        @Override
        boolean mustBeOptional() {
            return false;
        }

        @Override
        boolean isRequiredToBePresent() {
            return false;
        }

        @Override
        String propertyName() {
            return "items";
        }

        @Override
        Set<ShapeType> validTargets() {
            return ITEM_SHAPES;
        }

        @Override
        Optional<String> getMemberName(OperationIndex index, OperationShape operation, PaginatedTrait trait) {
            return trait.getItems();
        }

        @Override
        Optional<MemberShape> getMember(OperationIndex index, OperationShape operation, PaginatedTrait trait) {
            return this.getMemberName(index, operation, trait).flatMap(memberName -> index.getOutput(operation).flatMap(output -> output.getMember((String)memberName)));
        }
    }

    private static final class PageSizeValidator
    extends PropertyValidator {
        private PageSizeValidator() {
        }

        @Override
        boolean mustBeOptional() {
            return true;
        }

        @Override
        boolean isRequiredToBePresent() {
            return false;
        }

        @Override
        String propertyName() {
            return "pageSize";
        }

        @Override
        Set<ShapeType> validTargets() {
            return PAGE_SHAPES;
        }

        @Override
        Optional<String> getMemberName(OperationIndex index, OperationShape operation, PaginatedTrait trait) {
            return trait.getPageSize();
        }

        @Override
        Optional<MemberShape> getMember(OperationIndex index, OperationShape operation, PaginatedTrait trait) {
            return this.getMemberName(index, operation, trait).flatMap(memberName -> index.getInput(operation).flatMap(input -> input.getMember((String)memberName)));
        }
    }

    private static final class OutputTokenValidator
    extends PropertyValidator {
        private OutputTokenValidator() {
        }

        @Override
        boolean mustBeOptional() {
            return true;
        }

        @Override
        boolean isRequiredToBePresent() {
            return true;
        }

        @Override
        String propertyName() {
            return "outputToken";
        }

        @Override
        Set<ShapeType> validTargets() {
            return STRING_SET;
        }

        @Override
        Optional<String> getMemberName(OperationIndex index, OperationShape operation, PaginatedTrait trait) {
            return trait.getOutputToken();
        }

        @Override
        Optional<MemberShape> getMember(OperationIndex index, OperationShape operation, PaginatedTrait trait) {
            return this.getMemberName(index, operation, trait).flatMap(memberName -> index.getOutput(operation).flatMap(output -> output.getMember((String)memberName)));
        }
    }

    private static final class InputTokenValidator
    extends PropertyValidator {
        private InputTokenValidator() {
        }

        @Override
        boolean mustBeOptional() {
            return true;
        }

        @Override
        boolean isRequiredToBePresent() {
            return true;
        }

        @Override
        String propertyName() {
            return "inputToken";
        }

        @Override
        Set<ShapeType> validTargets() {
            return STRING_SET;
        }

        @Override
        Optional<String> getMemberName(OperationIndex index, OperationShape operation, PaginatedTrait trait) {
            return trait.getInputToken();
        }

        @Override
        Optional<MemberShape> getMember(OperationIndex index, OperationShape operation, PaginatedTrait trait) {
            return this.getMemberName(index, operation, trait).flatMap(memberName -> index.getInput(operation).flatMap(input -> input.getMember((String)memberName)));
        }
    }

    private static abstract class PropertyValidator {
        private PropertyValidator() {
        }

        abstract boolean mustBeOptional();

        abstract boolean isRequiredToBePresent();

        abstract String propertyName();

        abstract Set<ShapeType> validTargets();

        abstract Optional<String> getMemberName(OperationIndex var1, OperationShape var2, PaginatedTrait var3);

        abstract Optional<MemberShape> getMember(OperationIndex var1, OperationShape var2, PaginatedTrait var3);
    }
}

