/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.OutputTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;

public final class InputOutputStructureReuseValidator
extends AbstractValidator {
    private static final String INPUT = "Input";
    private static final String OUTPUT = "Output";

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        OperationIndex index = OperationIndex.of((Model)model);
        for (OperationShape operation : model.getOperationShapes()) {
            StructureShape input = index.expectInputShape((ToShapeId)operation);
            StructureShape output = index.expectOutputShape((ToShapeId)operation);
            this.validateInputOutputSet(operation, input, output, events);
        }
        return events;
    }

    private void validateInputOutputSet(OperationShape operation, StructureShape input, StructureShape output, List<ValidationEvent> events) {
        if (!input.hasTrait(InputTrait.ID)) {
            events.add(this.warning((Shape)input, String.format("This structure is the input of `%s`, but it is not marked with the @input trait. The @input trait gives operations more flexibility to evolve their top-level input members in ways that would otherwise be backward incompatible.", operation.getId()), INPUT, operation.getId().getName()));
        }
        if (!output.hasTrait(OutputTrait.ID)) {
            events.add(this.warning((Shape)output, String.format("This structure is the output of `%s`, but it is not marked with the @output trait.", operation.getId()), OUTPUT, operation.getId().getName()));
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(InputOutputStructureReuseValidator.class, InputOutputStructureReuseValidator::new);
        }
    }
}

