/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import software.amazon.smithy.utils.StringUtils;

final class WildcardMatcher
implements Predicate<String> {
    private final List<Predicate<String>> predicates = new ArrayList<Predicate<String>>();

    WildcardMatcher() {
    }

    @Override
    public boolean test(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return false;
        }
        text = text.toLowerCase(Locale.ENGLISH);
        for (Predicate<String> predicate : this.predicates) {
            if (!predicate.test(text)) continue;
            return true;
        }
        return false;
    }

    void addSearch(String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            throw new IllegalArgumentException("Invalid empty pattern");
        }
        if (pattern.equals("*")) {
            throw new IllegalArgumentException("Invalid wildcard pattern: *");
        }
        this.predicates.add(WildcardMatcher.parseWildcardPattern(pattern));
    }

    private static Predicate<String> parseWildcardPattern(String pattern) {
        boolean suffix = false;
        boolean prefix = false;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                if (i == 0) {
                    suffix = true;
                    continue;
                }
                if (i == pattern.length() - 1) {
                    prefix = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid inner '*' in wildcard pattern: " + pattern);
            }
            result.append(Character.toLowerCase(c));
        }
        String needle = result.toString();
        if (suffix && prefix) {
            return text -> text.contains(needle);
        }
        if (suffix) {
            return text -> text.endsWith(needle);
        }
        if (prefix) {
            return text -> text.startsWith(needle);
        }
        return text -> text.equals(needle);
    }
}

