/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import software.amazon.smithy.utils.StringUtils;

final class WordBoundaryMatcher
implements Predicate<String> {
    private final Set<String> words = new HashSet<String>();
    private final Map<String, String> searchCache = new LinkedHashMap<String, String>(128, 1.0f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 127;
        }
    };

    WordBoundaryMatcher() {
    }

    public void addSearch(String terms) {
        if (StringUtils.isEmpty((CharSequence)terms)) {
            throw new IllegalArgumentException("Invalid empty search terms");
        }
        String wordPattern = WordBoundaryMatcher.parseWordPattern(terms);
        this.words.add(wordPattern);
        this.words.add(wordPattern.replace(" ", ""));
    }

    @Override
    public boolean test(String text) {
        if (text == null || text.isEmpty() || this.words.isEmpty()) {
            return false;
        }
        String searchString = this.searchCache.computeIfAbsent(text, WordBoundaryMatcher::splitWords);
        for (String needle : this.words) {
            if (!this.testWordMatch(needle, searchString)) continue;
            return true;
        }
        return false;
    }

    private boolean testWordMatch(String needle, String haystack) {
        int position = haystack.indexOf(needle);
        int haystackLength = haystack.length();
        int needleLength = needle.length();
        if (position == -1) {
            return false;
        }
        if (needleLength == haystackLength) {
            return true;
        }
        if (position == 0) {
            return haystack.charAt(needleLength) == ' ';
        }
        if (position == haystackLength - needleLength) {
            return haystack.charAt(position - 1) == ' ';
        }
        return haystack.charAt(position - 1) == ' ' && haystack.charAt(position + needleLength) == ' ';
    }

    private static String parseWordPattern(String pattern) {
        boolean previousSpace = false;
        StringBuilder result = new StringBuilder(pattern.length() - 2);
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(Character.toLowerCase(c));
            if (c == ' ') {
                if (i == 0 || i == pattern.length() - 1 || previousSpace) {
                    throw new IllegalArgumentException("Invalid spaces in word boundary search: " + pattern);
                }
                previousSpace = true;
                continue;
            }
            if (!Character.isLetterOrDigit(c)) {
                throw new IllegalArgumentException("Invalid non-alphanumeric characters in word boundary search:" + pattern);
            }
            previousSpace = false;
        }
        return result.toString();
    }

    private static String splitWords(String str) {
        if (str.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int tokenStart = 0;
        int currentType = Character.getType(str.charAt(tokenStart));
        for (int pos = tokenStart + 1; pos < str.length(); ++pos) {
            char c = str.charAt(pos);
            int type = Character.getType(c);
            if (type == currentType) continue;
            if (type == 2 && currentType == 1) {
                int newTokenStart = pos - 1;
                if (newTokenStart != tokenStart) {
                    WordBoundaryMatcher.addLowerCaseStringToBuilder(result, str, tokenStart, newTokenStart - tokenStart);
                    result.append(' ');
                    tokenStart = newTokenStart;
                }
            } else {
                if (Character.isLetterOrDigit(str.charAt(pos - 1))) {
                    WordBoundaryMatcher.addLowerCaseStringToBuilder(result, str, tokenStart, pos - tokenStart);
                    result.append(' ');
                }
                tokenStart = pos;
            }
            currentType = type;
        }
        if (Character.isLetterOrDigit(str.charAt(tokenStart))) {
            WordBoundaryMatcher.addLowerCaseStringToBuilder(result, str, tokenStart, str.length() - tokenStart);
        } else {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    private static void addLowerCaseStringToBuilder(StringBuilder result, String str, int start, int count) {
        for (int i = start; i < start + count; ++i) {
            result.append(Character.toLowerCase(str.charAt(i)));
        }
    }
}

