/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.knowledge.TextIndex;
import software.amazon.smithy.model.knowledge.TextInstance;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.StringUtils;

public final class NoninclusiveTermsValidator
extends AbstractValidator {
    static final Map<String, List<String>> BUILT_IN_NONINCLUSIVE_TERMS = MapUtils.of((Object)"master", (Object)ListUtils.of((Object[])new String[]{"primary", "parent", "main"}), (Object)"slave", (Object)ListUtils.of((Object[])new String[]{"secondary", "replica", "clone", "child"}), (Object)"blacklist", (Object)ListUtils.of((Object)"denyList"), (Object)"whitelist", (Object)ListUtils.of((Object)"allowList"));
    private final Map<String, List<String>> termsMap;

    private NoninclusiveTermsValidator(Config config) {
        HashMap<String, List<String>> termsMapInit = new HashMap<String, List<String>>(BUILT_IN_NONINCLUSIVE_TERMS);
        if (!config.getExcludeDefaults()) {
            termsMapInit.putAll(config.getTerms());
            this.termsMap = Collections.unmodifiableMap(termsMapInit);
        } else {
            if (config.getTerms().isEmpty()) {
                throw new IllegalArgumentException("Cannot set 'excludeDefaults' to true and leave 'terms' empty or unspecified.");
            }
            this.termsMap = Collections.unmodifiableMap(config.getTerms());
        }
    }

    public List<ValidationEvent> validate(Model model) {
        TextIndex textIndex = TextIndex.of((Model)model);
        ArrayList<ValidationEvent> validationEvents = new ArrayList<ValidationEvent>();
        for (TextInstance text : textIndex.getTextInstances()) {
            validationEvents.addAll(this.getValidationEvents(text));
        }
        return validationEvents;
    }

    private Collection<ValidationEvent> getValidationEvents(TextInstance instance) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        block4: for (Map.Entry<String, List<String>> termEntry : this.termsMap.entrySet()) {
            String termLower = termEntry.getKey().toLowerCase();
            int startIndex = instance.getText().toLowerCase().indexOf(termLower);
            if (startIndex == -1) continue;
            String matchedText = instance.getText().substring(startIndex, startIndex + termLower.length());
            switch (instance.getLocationType()) {
                case NAMESPACE: {
                    events.add(ValidationEvent.builder().sourceLocation((FromSourceLocation)SourceLocation.none()).id(((Object)((Object)this)).getClass().getSimpleName().replaceFirst("Validator$", "")).severity(Severity.WARNING).message(NoninclusiveTermsValidator.formatNonInclusiveTermsValidationMessage(termEntry, matchedText, instance)).build());
                    continue block4;
                }
                case APPLIED_TRAIT: {
                    events.add(this.warning(instance.getShape(), (FromSourceLocation)instance.getTrait().getSourceLocation(), NoninclusiveTermsValidator.formatNonInclusiveTermsValidationMessage(termEntry, matchedText, instance)));
                    continue block4;
                }
            }
            events.add(this.warning(instance.getShape(), (FromSourceLocation)instance.getShape().getSourceLocation(), NoninclusiveTermsValidator.formatNonInclusiveTermsValidationMessage(termEntry, matchedText, instance)));
        }
        return events;
    }

    private static String formatNonInclusiveTermsValidationMessage(Map.Entry<String, List<String>> termEntry, String matchedText, TextInstance instance) {
        List caseCorrectedEntryValue = termEntry.getValue().stream().map(replacement -> Character.isUpperCase(matchedText.charAt(0)) ? StringUtils.capitalize((String)replacement) : StringUtils.uncapitalize((String)replacement)).collect(Collectors.toList());
        String replacementAddendum = !termEntry.getValue().isEmpty() ? String.format(" Consider using one of the following terms instead: %s", ValidationUtils.tickedList(caseCorrectedEntryValue)) : "";
        switch (instance.getLocationType()) {
            case SHAPE: {
                return String.format("%s shape uses a non-inclusive term `%s`.%s", StringUtils.capitalize((String)instance.getShape().getType().toString()), matchedText, replacementAddendum);
            }
            case NAMESPACE: {
                return String.format("%s namespace uses a non-inclusive term `%s`.%s", instance.getText(), matchedText, replacementAddendum);
            }
            case APPLIED_TRAIT: {
                if (instance.getTraitPropertyPath().isEmpty()) {
                    return String.format("'%s' trait has a value that contains a non-inclusive term `%s`.%s", Trait.getIdiomaticTraitName((ToShapeId)instance.getTrait()), matchedText, replacementAddendum);
                }
                String valuePropertyPathFormatted = NoninclusiveTermsValidator.formatPropertyPath(instance.getTraitPropertyPath());
                return String.format("'%s' trait value at path {%s} contains a non-inclusive term `%s`.%s", Trait.getIdiomaticTraitName((ToShapeId)instance.getTrait()), valuePropertyPathFormatted, matchedText, replacementAddendum);
            }
        }
        throw new IllegalStateException();
    }

    private static String formatPropertyPath(List<String> traitPropertyPath) {
        return String.join((CharSequence)"/", traitPropertyPath);
    }

    public static final class Config {
        private Map<String, List<String>> terms = MapUtils.of();
        private boolean excludeDefaults;

        public Map<String, List<String>> getTerms() {
            return this.terms;
        }

        public void setTerms(Map<String, List<String>> terms) {
            this.terms = terms;
        }

        public boolean getExcludeDefaults() {
            return this.excludeDefaults;
        }

        public void setExcludeDefaults(boolean excludeDefaults) {
            this.excludeDefaults = excludeDefaults;
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(NoninclusiveTermsValidator.class, node -> {
                NodeMapper mapper = new NodeMapper();
                return new NoninclusiveTermsValidator((Config)mapper.deserialize((Node)node, Config.class));
            });
        }
    }
}

