/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.PaginatedTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SetUtils;

public final class MissingPaginatedTraitValidator
extends AbstractValidator {
    private static final Set<String> DEFAULT_VERBS_REQUIRE = SetUtils.of((Object[])new String[]{"list", "search"});
    private static final Set<String> DEFAULT_VERBS_SUGGEST = SetUtils.of((Object[])new String[]{"describe", "get"});
    private static final Set<String> DEFAULT_INPUT_MEMBERS = SetUtils.of((Object[])new String[]{"maxresults", "pagesize", "limit", "nexttoken", "pagetoken", "token"});
    private static final Set<String> DEFAULT_OUTPUT_MEMBERS = SetUtils.of((Object[])new String[]{"nexttoken", "pagetoken", "token", "marker", "nextpage"});
    private static final String DISCLAIMER = "Paginating operations that can return potentially unbounded lists of data helps to maintain a predictable SLA and helps to prevent operational issues in the future.";
    private final Config config;

    private MissingPaginatedTraitValidator(Config config) {
        this.config = config;
    }

    private static Optional<String> findMember(Collection<String> haystack, Collection<String> needles) {
        return haystack.stream().filter(member -> needles.contains(member.toLowerCase(Locale.US))).findFirst();
    }

    public List<ValidationEvent> validate(Model model) {
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        return model.shapes(OperationShape.class).filter(shape -> !shape.getTrait(PaginatedTrait.class).isPresent()).flatMap(shape -> this.validateShape(model, operationIndex, (OperationShape)shape)).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateShape(Model model, OperationIndex operationIndex, OperationShape operation) {
        List words = ValidationUtils.splitCamelCaseWord((String)operation.getId().getName());
        String verb = ((String)words.get(0)).toLowerCase(Locale.US);
        if (this.config.getVerbsRequirePagination().contains(verb)) {
            return Stream.of(this.danger((Shape)operation, String.format("The verb of this operation, `%s`, requires that the operation is marked with the `paginated` trait. %s", verb, DISCLAIMER)));
        }
        StructureShape input = operationIndex.expectInputShape((ToShapeId)operation.getId());
        Optional<String> member = MissingPaginatedTraitValidator.findMember(input.getAllMembers().keySet(), this.config.getInputMembersRequirePagination());
        if (member.isPresent()) {
            return Stream.of(this.danger((Shape)operation, String.format("This operation contains an input member, `%s`, that requires that the operation is marked with the `paginated` trait. %s", member.get(), DISCLAIMER)));
        }
        StructureShape output = operationIndex.expectOutputShape((ToShapeId)operation.getId());
        return MissingPaginatedTraitValidator.findMember(output.getAllMembers().keySet(), this.config.getOutputMembersRequirePagination()).map(outputMember -> Stream.of(this.danger((Shape)operation, String.format("This operation contains an output member, `%s`, that requires that the operation is marked with the `paginated` trait. %s", outputMember, DISCLAIMER)))).orElseGet(() -> this.suggestPagination(verb, operation, output, model));
    }

    private Stream<ValidationEvent> suggestPagination(String verb, OperationShape operation, StructureShape output, Model model) {
        if (!this.config.getVerbsSuggestPagination().contains(verb)) {
            return Stream.empty();
        }
        boolean hasListMember = output.getAllMembers().values().stream().map(MemberShape::getTarget).flatMap(id -> OptionalUtils.stream((Optional)model.getShape(id))).anyMatch(Shape::isListShape);
        if (!hasListMember) {
            return Stream.empty();
        }
        return Stream.of(this.warning((Shape)operation, String.format("The verb of this operation, `%s`, and the presence of a top-level list member in its output, suggests that the operation should have the `paginated` trait. %s", verb, DISCLAIMER)));
    }

    static /* synthetic */ Set access$000() {
        return DEFAULT_VERBS_REQUIRE;
    }

    static /* synthetic */ Set access$100() {
        return DEFAULT_VERBS_SUGGEST;
    }

    static /* synthetic */ Set access$200() {
        return DEFAULT_INPUT_MEMBERS;
    }

    static /* synthetic */ Set access$300() {
        return DEFAULT_OUTPUT_MEMBERS;
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(MissingPaginatedTraitValidator.class, node -> {
                Config config = (Config)new NodeMapper().deserialize((Node)node, Config.class);
                return new MissingPaginatedTraitValidator(config);
            });
        }
    }

    public static final class Config {
        private Set<String> verbsRequirePagination = MissingPaginatedTraitValidator.access$000();
        private Set<String> verbsSuggestPagination = MissingPaginatedTraitValidator.access$100();
        private Set<String> inputMembersRequirePagination = MissingPaginatedTraitValidator.access$200();
        private Set<String> outputMembersRequirePagination = MissingPaginatedTraitValidator.access$300();

        public Set<String> getVerbsRequirePagination() {
            return this.verbsRequirePagination;
        }

        public void setVerbsRequirePagination(Set<String> verbsRequirePagination) {
            this.verbsRequirePagination = this.lowercaseSet(verbsRequirePagination);
        }

        public Set<String> getVerbsSuggestPagination() {
            return this.verbsSuggestPagination;
        }

        public void setVerbsSuggestPagination(Set<String> verbsSuggestPagination) {
            this.verbsSuggestPagination = this.lowercaseSet(verbsSuggestPagination);
        }

        public Set<String> getInputMembersRequirePagination() {
            return this.inputMembersRequirePagination;
        }

        public void setInputMembersRequirePagination(Set<String> inputMembersRequirePagination) {
            this.inputMembersRequirePagination = this.lowercaseSet(inputMembersRequirePagination);
        }

        public Set<String> getOutputMembersRequirePagination() {
            return this.outputMembersRequirePagination;
        }

        public void setOutputMembersRequirePagination(Set<String> outputMembersRequirePagination) {
            this.outputMembersRequirePagination = this.lowercaseSet(outputMembersRequirePagination);
        }

        private Set<String> lowercaseSet(Set<String> set) {
            HashSet<String> result = new HashSet<String>(set.size());
            for (String entry : set) {
                result.add(entry.toLowerCase(Locale.ENGLISH));
            }
            return result;
        }
    }
}

