/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.selector.SelectorSyntaxException;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.OptionalUtils;

public final class ReservedWordsValidator
extends AbstractValidator {
    private static final Pattern CONTAINS_INNER_WILDCARD = Pattern.compile("^.+\\*.+$");
    private final List<ReservedWords> reservations;

    private ReservedWordsValidator(List<ReservedWords> reservations) {
        this.reservations = reservations;
    }

    public List<ValidationEvent> validate(Model model) {
        return this.reservations.stream().flatMap(reservation -> ((ReservedWords)reservation).validate(model)).collect(Collectors.toList());
    }

    private static ReservedWords createConfiguration(ObjectNode node) {
        return new ReservedWords(ReservedWordsValidator.parseReservedWords(node), node.getStringMember("selector").orElse(Node.from((String)"*")), node.getStringMember("reason").map(StringNode::getValue).orElse(""));
    }

    private static List<String> parseReservedWords(ObjectNode node) {
        return node.getArrayMember("words").map(reservations -> reservations.getElements().stream().map(Node::expectStringNode).map(ReservedWordsValidator::getValidReservationOrThrow).collect(Collectors.toList())).orElseThrow(() -> new SourceException("A reservation must supply an array of strings under `words`.", (FromSourceLocation)node));
    }

    private static String getValidReservationOrThrow(StringNode string) {
        String value = string.getValue();
        if (value.equals("*")) {
            throw new SourceException("Reservations cannot be made against '*'", (FromSourceLocation)string);
        }
        if (CONTAINS_INNER_WILDCARD.matcher(value).find()) {
            throw new SourceException("Only preceding and trailing wildcards ('*') are supported.", (FromSourceLocation)string);
        }
        return value.toLowerCase(Locale.US);
    }

    private static final class ReservedWords {
        private List<String> reservations;
        private Selector selector;
        private String reason;

        private ReservedWords(List<String> reservations, StringNode selector, String reason) {
            this.reservations = reservations;
            this.selector = this.parse(selector);
            this.reason = reason;
        }

        private Selector parse(StringNode expression) {
            try {
                return Selector.parse((String)expression.getValue().trim());
            }
            catch (SelectorSyntaxException e) {
                throw new SourceException("Invalid selector expression: " + e.getMessage(), (FromSourceLocation)expression, (Throwable)e);
            }
        }

        private Stream<ValidationEvent> validate(Model model) {
            return this.selector.select(model).stream().flatMap(shape -> OptionalUtils.stream(this.validateShape((Shape)shape)));
        }

        private Optional<ValidationEvent> validateShape(Shape shape) {
            String name = shape.asMemberShape().map(MemberShape::getMemberName).orElseGet(() -> shape.getId().getName());
            return this.isReservedWord(name) ? Optional.of(this.emit(shape, name, this.reason)) : Optional.empty();
        }

        private boolean isReservedWord(String word) {
            String compare = word.toLowerCase(Locale.US);
            return this.reservations.stream().anyMatch(reservation -> {
                if (reservation.startsWith("*")) {
                    if (reservation.endsWith("*")) {
                        return compare.contains(reservation.substring(1, reservation.lastIndexOf("*")));
                    }
                    return compare.endsWith(reservation.substring(1));
                }
                if (reservation.endsWith("*")) {
                    return compare.startsWith(reservation.substring(0, reservation.lastIndexOf("*")));
                }
                return compare.equals(reservation);
            });
        }

        private ValidationEvent emit(Shape shape, String word, String reason) {
            return ValidationEvent.builder().severity(Severity.DANGER).eventId(ValidatorService.determineValidatorName(ReservedWordsValidator.class)).shape(shape).message(String.format("The word `%s` is reserved. %s", word, reason)).build();
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(ReservedWordsValidator.class, node -> new ReservedWordsValidator(node.expectArrayMember("reserved").getElements().stream().map(Node::expectObjectNode).map(x$0 -> ReservedWordsValidator.createConfiguration(x$0)).collect(Collectors.toList())));
        }
    }
}

