/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.FunctionalUtils;

public final class CamelCaseValidator
extends AbstractValidator {
    private static final String UPPER = "upper";
    private static final String LOWER = "lower";
    private static final Pattern UPPER_CAMEL_CASE = Pattern.compile("^[A-Z]+[A-Za-z0-9]*$");
    private static final Pattern LOWER_CAMEL_CASE = Pattern.compile("^[a-z]+[A-Za-z0-9]*$");
    private final String memberNames;

    private CamelCaseValidator(String memberNames) {
        this.memberNames = memberNames;
    }

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        model.shapes().filter(FunctionalUtils.not(Shape::isMemberShape)).filter(shape -> !shape.hasTrait(TraitDefinition.class)).filter(shape -> !CamelCaseValidator.getPattern(UPPER).matcher(shape.getId().getName()).find()).map(shape -> this.danger((Shape)shape, String.format("%s shape name, `%s`, is not %s camel case", shape.getType(), shape.getId().getName(), UPPER))).forEach(events::add);
        model.shapes().filter(shape -> shape.hasTrait(TraitDefinition.class)).filter(shape -> !CamelCaseValidator.getPattern(LOWER).matcher(shape.getId().getName()).find()).map(shape -> this.danger((Shape)shape, String.format("%s trait definition, `%s`, is not lower camel case", shape.getType(), shape.getId().getName()))).forEach(events::add);
        Pattern isValidMemberName = CamelCaseValidator.getPattern(this.memberNames);
        model.shapes(MemberShape.class).filter(shape -> !isValidMemberName.matcher(shape.getMemberName()).find()).map(shape -> this.danger((Shape)shape, String.format("Member shape member name, `%s`, is not %s camel case", shape.getMemberName(), this.memberNames))).forEach(events::add);
        return events;
    }

    private static Pattern getPattern(String upperOrLower) {
        return upperOrLower.equals(UPPER) ? UPPER_CAMEL_CASE : LOWER_CAMEL_CASE;
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(CamelCaseValidator.class, configuration -> {
                String memberNames = configuration.getStringMember("memberNames").orElseGet(() -> Node.from((String)CamelCaseValidator.LOWER)).expectOneOf(new String[]{CamelCaseValidator.UPPER, CamelCaseValidator.LOWER});
                return new CamelCaseValidator(memberNames);
            });
        }
    }
}

