/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public final class StandardOperationVerbValidator
extends AbstractValidator {
    private final List<String> verbs;
    private final List<String> prefixes;
    private final Map<String, List<String>> alts;

    private StandardOperationVerbValidator(List<String> verbs, List<String> prefixes, Map<String, List<String>> alts) {
        this.verbs = verbs;
        this.prefixes = prefixes;
        this.alts = alts;
    }

    private static Map<String, List<String>> extractAlternatives(ObjectNode node) {
        return node.getObjectMember("suggestAlternatives").map(ObjectNode::getMembers).map(map -> map.entrySet().stream().map(entry -> Pair.of((Object)((StringNode)entry.getKey()).getValue(), (Object)Node.loadArrayOfString((String)((StringNode)entry.getKey()).getValue(), (Node)((Node)entry.getValue())))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight))).orElse(MapUtils.of());
    }

    public List<ValidationEvent> validate(Model model) {
        return model.getShapeIndex().shapes(OperationShape.class).flatMap(shape -> OptionalUtils.stream(this.validateShape((OperationShape)shape, this.verbs, this.prefixes, this.alts))).collect(Collectors.toList());
    }

    private Optional<ValidationEvent> validateShape(OperationShape operation, List<String> verbs, List<String> prefixes, Map<String, List<String>> alts) {
        String name;
        List words = ValidationUtils.splitCamelCaseWord((String)operation.getId().getName());
        String foundPrefix = null;
        if (!prefixes.contains(words.get(0))) {
            name = (String)words.get(0);
        } else {
            if (words.size() == 1) {
                return Optional.of(this.danger((Shape)operation, String.format("Operation name consists of only a verb prefix: %s", operation.getId().getName())));
            }
            foundPrefix = (String)words.get(0);
            name = (String)words.get(1);
        }
        if (alts.containsKey(name)) {
            return Optional.of(this.danger((Shape)operation, String.format("%s Consider using one of the following verbs instead: %s", StandardOperationVerbValidator.createMessagePrefix((Shape)operation, name, foundPrefix), ValidationUtils.tickedList((Collection)alts.get(name)))));
        }
        if (!verbs.contains(name)) {
            return Optional.of(this.danger((Shape)operation, String.format("%s Expected one of the following verbs: %s", StandardOperationVerbValidator.createMessagePrefix((Shape)operation, name, foundPrefix), ValidationUtils.tickedList(verbs))));
        }
        return Optional.empty();
    }

    private static String createMessagePrefix(Shape shape, String name, String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Operation shape `%s` uses a non-standard verb, `%s`", shape.getId().getName(), name));
        if (prefix != null) {
            builder.append(String.format(", with a detected prefix of `%s`", prefix));
        }
        return builder.append(".").toString();
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(StandardOperationVerbValidator.class, node -> {
                List verbs = Node.loadArrayOfString((String)"verbs", (Node)node.getMember("verbs").orElseGet(Node::arrayNode));
                List prefixes = Node.loadArrayOfString((String)"prefixes", (Node)node.getMember("prefixes").orElseGet(Node::arrayNode));
                Map suggestAlternatives = StandardOperationVerbValidator.extractAlternatives(node);
                if (verbs.isEmpty() && suggestAlternatives.isEmpty()) {
                    throw new SourceException("Either verbs or suggestAlternatives must be set when configuring StandardOperationVerb", (FromSourceLocation)node);
                }
                return new StandardOperationVerbValidator(verbs, prefixes, suggestAlternatives);
            });
        }
    }
}

