/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.OptionalUtils;

public final class ShouldHaveUsedTimestampValidator
extends AbstractValidator {
    private static final List<String> ATTRIBUTES = ListUtils.of((Object)"additionalPatterns");
    private static final List<Pattern> DEFAULT_PATTERNS = ListUtils.of((Object[])new Pattern[]{Pattern.compile("^.*[Tt]imestamp.*$"), Pattern.compile("^[Tt]ime([_A-Z].*)?$"), Pattern.compile("^[Dd]ate([_A-Z].*)?$"), Pattern.compile("^.*([a-z]T|_[Tt])ime$"), Pattern.compile("^.*([a-z]D|_[Dd])ate$"), Pattern.compile("^.*([a-z]A|_[Aa])t$"), Pattern.compile("^.*([a-z]O|_[Oo])n$")});
    private final List<Pattern> patterns;

    private ShouldHaveUsedTimestampValidator(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    public List<ValidationEvent> validate(Model model) {
        ShapeIndex index = model.getShapeIndex();
        ShapeVisitor visitor = Shape.visitor().when(StringShape.class, s -> this.validateSimpleShape((Shape)s, this.patterns)).when(ShortShape.class, s -> this.validateSimpleShape((Shape)s, this.patterns)).when(IntegerShape.class, s -> this.validateSimpleShape((Shape)s, this.patterns)).when(LongShape.class, s -> this.validateSimpleShape((Shape)s, this.patterns)).when(FloatShape.class, s -> this.validateSimpleShape((Shape)s, this.patterns)).when(StructureShape.class, shape -> this.validateStructure((StructureShape)shape, index, this.patterns)).when(UnionShape.class, shape -> this.validateUnion((UnionShape)shape, index, this.patterns)).orElse((Object)ListUtils.of());
        return index.shapes().flatMap(shape -> ((List)shape.accept(visitor)).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateStructure(StructureShape structure, ShapeIndex shapeIndex, List<Pattern> patterns) {
        return structure.getAllMembers().entrySet().stream().flatMap(entry -> this.validateTargetShape((String)entry.getKey(), (MemberShape)entry.getValue(), shapeIndex, patterns)).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateUnion(UnionShape union, ShapeIndex shapeIndex, List<Pattern> patterns) {
        return union.getAllMembers().entrySet().stream().flatMap(entry -> this.validateTargetShape((String)entry.getKey(), (MemberShape)entry.getValue(), shapeIndex, patterns)).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateTargetShape(String name, MemberShape target, ShapeIndex shapeIndex, List<Pattern> patterns) {
        return OptionalUtils.stream(shapeIndex.getShape(target.getTarget()).flatMap(shape -> this.validateName(name, shape.getType(), (Shape)target, patterns)));
    }

    private List<ValidationEvent> validateSimpleShape(Shape shape, List<Pattern> patterns) {
        return this.validateName(shape.getId().getName(), shape.getType(), shape, patterns).map(ListUtils::of).orElse(ListUtils.of());
    }

    private Optional<ValidationEvent> validateName(String name, ShapeType type, Shape context, List<Pattern> patterns) {
        if (type == ShapeType.TIMESTAMP) {
            return Optional.empty();
        }
        return patterns.stream().filter(pattern -> pattern.matcher(name).matches()).map(matcher -> this.buildEvent(context, name, type)).findAny();
    }

    private ValidationEvent buildEvent(Shape context, String name, ShapeType type) {
        return this.danger(context, context.isMemberShape() ? String.format("Member `%s` is named like a timestamp but references a `%s` shape", name, type) : String.format("Shape `%s` is named like a timestamp but is a `%s` shape.", name, type));
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(ShouldHaveUsedTimestampValidator.class, configuration -> {
                ArrayList patterns = new ArrayList(DEFAULT_PATTERNS);
                ((Node)configuration.warnIfAdditionalProperties((Collection)ATTRIBUTES).getMember("additionalPatterns").orElse(Node.arrayNode())).expectArrayNode().getElements().stream().map(node -> Pattern.compile(node.expectStringNode().getValue())).forEach(patterns::add);
                return new ShouldHaveUsedTimestampValidator(patterns);
            });
        }
    }
}

