/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.PaginatedTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.StringUtils;

public final class MissingPaginatedTraitValidator
extends AbstractValidator {
    private static final String DISCLAIMER = "Paginating operations that can return potentially unbounded lists of data helps to maintain a predictable SLA and helps to prevent operational issues in the future.";
    private static final Set<String> DEFAULT_VERBS_REQUIRE = SetUtils.of((Object[])new String[]{"list", "search"});
    private static final Set<String> DEFAULT_VERBS_SUGGEST = SetUtils.of((Object[])new String[]{"describe", "get"});
    private static final Set<String> DEFAULT_INPUT_MEMBERS = SetUtils.of((Object[])new String[]{"maxresults", "pagesize", "limit", "nexttoken", "pagetoken", "token"});
    private static final Set<String> DEFAULT_OUTPUT_MEMBERS = SetUtils.of((Object[])new String[]{"nexttoken", "pagetoken", "token", "marker", "nextpage"});
    private final Set<String> verbsRequirePagination;
    private final Set<String> verbsSuggestPagination;
    private final Set<String> inputMembersRequirePagination;
    private final Set<String> outputMembersRequirePagination;

    private MissingPaginatedTraitValidator(Set<String> verbsRequirePagination, Set<String> verbsSuggestPagination, Set<String> inputMembersRequirePagination, Set<String> outputMembersRequirePagination) {
        this.verbsRequirePagination = verbsRequirePagination;
        this.verbsSuggestPagination = verbsSuggestPagination;
        this.inputMembersRequirePagination = inputMembersRequirePagination;
        this.outputMembersRequirePagination = outputMembersRequirePagination;
    }

    private static Set<String> parseSetOfString(ObjectNode node, String member, Set<String> defaults) {
        Optional arrayMember = node.getArrayMember(member);
        return arrayMember.isPresent() ? Node.loadArrayOfString((String)member, (Node)((Node)arrayMember.get())).stream().map(StringUtils::lowerCase).collect(Collectors.toSet()) : defaults;
    }

    private static Optional<String> findMember(Collection<String> haystack, Collection<String> needles) {
        return haystack.stream().filter(member -> needles.contains(member.toLowerCase(Locale.US))).findFirst();
    }

    public List<ValidationEvent> validate(Model model) {
        OperationIndex operationIndex = (OperationIndex)model.getKnowledge(OperationIndex.class);
        return model.getShapeIndex().shapes(OperationShape.class).filter(shape -> !shape.getTrait(PaginatedTrait.class).isPresent()).flatMap(shape -> this.validateShape(model.getShapeIndex(), operationIndex, (OperationShape)shape)).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateShape(ShapeIndex index, OperationIndex operationIndex, OperationShape operation) {
        StructureShape input;
        Optional<String> member2;
        List words = ValidationUtils.splitCamelCaseWord((String)operation.getId().getName());
        String verb = ((String)words.get(0)).toLowerCase(Locale.US);
        if (this.verbsRequirePagination.contains(verb)) {
            return Stream.of(this.danger((Shape)operation, String.format("The verb of this operation, `%s`, requires that the operation is marked with the `paginated` trait. %s", verb, DISCLAIMER)));
        }
        if (operationIndex.getInput((ToShapeId)operation.getId()).isPresent() && (member2 = MissingPaginatedTraitValidator.findMember((input = (StructureShape)operationIndex.getInput((ToShapeId)operation.getId()).get()).getAllMembers().keySet(), this.inputMembersRequirePagination)).isPresent()) {
            return Stream.of(this.danger((Shape)operation, String.format("This operation contains an input member, `%s`, that requires that the operation is marked with the `paginated` trait. %s", member2.get(), DISCLAIMER)));
        }
        if (operationIndex.getOutput((ToShapeId)operation.getId()).isPresent()) {
            StructureShape output = (StructureShape)operationIndex.getOutput((ToShapeId)operation.getId()).get();
            return MissingPaginatedTraitValidator.findMember(output.getAllMembers().keySet(), this.outputMembersRequirePagination).map(member -> Stream.of(this.danger((Shape)operation, String.format("This operation contains an output member, `%s`, that requires that the operation is marked with the `paginated` trait. %s", member, DISCLAIMER)))).orElseGet(() -> this.suggestPagination(verb, operation, output, index));
        }
        return Stream.empty();
    }

    private Stream<ValidationEvent> suggestPagination(String verb, OperationShape operation, StructureShape output, ShapeIndex index) {
        if (!this.verbsSuggestPagination.contains(verb)) {
            return Stream.empty();
        }
        boolean hasListMember = output.getAllMembers().values().stream().map(MemberShape::getTarget).flatMap(id -> OptionalUtils.stream((Optional)index.getShape(id))).anyMatch(Shape::isListShape);
        if (!hasListMember) {
            return Stream.empty();
        }
        return Stream.of(this.warning((Shape)operation, String.format("The verb of this operation, `%s`, and the presence of a top-level list member in its output, suggests that the operation should have the `paginated` trait. %s", verb, DISCLAIMER)));
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(MissingPaginatedTraitValidator.class, node -> {
                Set verbsRequirePagination = MissingPaginatedTraitValidator.parseSetOfString(node, "verbsRequirePagination", DEFAULT_VERBS_REQUIRE);
                Set verbsSuggestPagination = MissingPaginatedTraitValidator.parseSetOfString(node, "verbsSuggestPagination", DEFAULT_VERBS_SUGGEST);
                Set inputMembersRequirePagination = MissingPaginatedTraitValidator.parseSetOfString(node, "inputMembersRequirePagination", DEFAULT_INPUT_MEMBERS);
                Set outputMembersRequirePagination = MissingPaginatedTraitValidator.parseSetOfString(node, "outputMembersRequirePagination", DEFAULT_OUTPUT_MEMBERS);
                return new MissingPaginatedTraitValidator(verbsRequirePagination, verbsSuggestPagination, inputMembersRequirePagination, outputMembersRequirePagination);
            });
        }
    }
}

