/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.UnreferencedShapes;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;

public final class UnreferencedShapeValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        return new UnreferencedShapes().compute(model).stream().map(shape -> this.note((Shape)shape, String.format("The %s %s shape is not connected to from any service shape.", shape.getId(), shape.getType()))).collect(Collectors.toList());
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(UnreferencedShapeValidator.class, UnreferencedShapeValidator::new);
        }
    }
}

