/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.Optional;
import java.util.regex.Pattern;
import software.amazon.smithy.jsonschema.JsonSchemaConfig;
import software.amazon.smithy.jsonschema.PropertyNamingStrategy;
import software.amazon.smithy.jsonschema.RefStrategy;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.EnumTrait;

final class DefaultRefStrategy
implements RefStrategy {
    private static final Pattern NON_ALPHA_NUMERIC = Pattern.compile("[^A-Za-z0-9]");
    private final Model model;
    private final String rootPointer;
    private final PropertyNamingStrategy propertyNamingStrategy;
    private final JsonSchemaConfig config;
    private final ServiceShape serviceContext;

    DefaultRefStrategy(Model model, JsonSchemaConfig config, PropertyNamingStrategy propertyNamingStrategy) {
        this.model = model;
        this.propertyNamingStrategy = propertyNamingStrategy;
        this.config = config;
        this.rootPointer = DefaultRefStrategy.computePointer(config);
        this.serviceContext = Optional.ofNullable(config.getService()).map(shape -> (ServiceShape)model.expectShape(shape, ServiceShape.class)).orElse(null);
    }

    private static String computePointer(JsonSchemaConfig config) {
        String pointer = config.getDefinitionPointer();
        if (!pointer.endsWith("/")) {
            pointer = pointer + "/";
        }
        return pointer;
    }

    @Override
    public String toPointer(ShapeId id) {
        if (id.getMember().isPresent()) {
            MemberShape member = (MemberShape)this.model.expectShape(id, MemberShape.class);
            return this.createMemberPointer(member);
        }
        String shapeName = id.getName();
        if (this.serviceContext != null) {
            shapeName = this.serviceContext.getContextualName((ToShapeId)id);
        }
        return this.rootPointer + this.stripNonAlphaNumericCharsIfNecessary(shapeName);
    }

    private String createMemberPointer(MemberShape member) {
        if (!this.isInlined((Shape)member)) {
            return this.toPointer(member.getTarget());
        }
        Shape container = this.model.expectShape(member.getContainer());
        String parentPointer = this.toPointer(container.getId());
        switch (container.getType()) {
            case LIST: 
            case SET: {
                return parentPointer + "/items";
            }
            case MAP: {
                return member.getMemberName().equals("key") ? parentPointer + "/propertyNames" : parentPointer + "/additionalProperties";
            }
        }
        return parentPointer + "/properties/" + this.propertyNamingStrategy.toPropertyName(container, member, this.config);
    }

    @Override
    public boolean isInlined(Shape shape) {
        if (shape.asMemberShape().isPresent()) {
            MemberShape member = (MemberShape)shape.asMemberShape().get();
            Shape target = this.model.expectShape(member.getTarget());
            return this.isInlined(target);
        }
        if (shape instanceof CollectionShape) {
            return true;
        }
        if (shape.isMapShape() && this.config.getUseInlineMaps()) {
            return true;
        }
        if (shape.hasTrait(EnumTrait.class)) {
            return false;
        }
        if (shape.isIntEnumShape() && !this.config.getDisableIntEnums()) {
            return false;
        }
        return shape instanceof SimpleShape;
    }

    private String stripNonAlphaNumericCharsIfNecessary(String result) {
        return this.config.getAlphanumericOnlyRefs() ? NON_ALPHA_NUMERIC.matcher(result).replaceAll("") : result;
    }
}

