/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.jsonschema.SchemaComparator;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class SchemaDocument
implements ToNode,
ToSmithyBuilder<SchemaDocument> {
    private static final Logger LOGGER = Logger.getLogger(SchemaDocument.class.getName());
    private final String idKeyword;
    private final String schemaKeyword;
    private final Schema rootSchema;
    private final Map<String, Schema> definitions;
    private final ObjectNode extensions;

    private SchemaDocument(Builder builder) {
        this.idKeyword = builder.idKeyword;
        this.schemaKeyword = builder.schemaKeyword;
        this.rootSchema = builder.rootSchema != null ? builder.rootSchema : Schema.builder().build();
        this.definitions = new LinkedHashMap<String, Schema>(builder.definitions);
        this.extensions = builder.extensions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Node toNode() {
        ObjectNode definitionNode = Node.objectNode();
        if (!this.definitions.isEmpty()) {
            LinkedHashMap<StringNode, Object> nodes = new LinkedHashMap<StringNode, Object>();
            for (Map.Entry<String, Schema> entry : this.definitions.entrySet()) {
                this.updateIn(nodes, entry.getKey(), entry.getValue().toNode());
            }
            definitionNode = Node.objectNode(this.convertMap(nodes));
        }
        return Node.objectNodeBuilder().withOptionalMember("$id", this.getIdKeyword().map(Node::from)).withOptionalMember("$schema", this.getSchemaKeyword().map(Node::from)).merge(this.rootSchema.toNode().expectObjectNode()).merge(this.extensions).merge(definitionNode).build().withDeepSortedKeys((Comparator)new SchemaComparator());
    }

    private void updateIn(Map<StringNode, Object> map, String key, Node value) {
        if (!key.startsWith("#/")) {
            LOGGER.warning(() -> "Unable to serialize a node for definition JSON pointer: " + key + ". Can only serialize pointers that start with '#/'.");
            return;
        }
        String[] paths = key.substring(2).split("/");
        if (paths.length <= 1) {
            throw new RuntimeException("Invalid definition JSON pointer. Expected more segments: " + key);
        }
        LinkedHashMap<StringNode, Object> current = map;
        for (int i = 0; i < paths.length - 1; ++i) {
            StringNode pathNode = Node.from((String)paths[i]);
            if (!current.containsKey(pathNode)) {
                LinkedHashMap<StringNode, Object> newEntry = new LinkedHashMap<StringNode, Object>();
                current.put(pathNode, newEntry);
                current = newEntry;
                continue;
            }
            if (!(current.get(pathNode) instanceof Map)) {
                throw new RuntimeException("Conflicting JSON pointer definition found at " + key);
            }
            current = (LinkedHashMap<StringNode, Object>)current.get(pathNode);
        }
        current.put(Node.from((String)paths[paths.length - 1]), value);
    }

    private Map<StringNode, Node> convertMap(Map<StringNode, Object> map) {
        HashMap<StringNode, Node> result = new HashMap<StringNode, Node>();
        for (Map.Entry<StringNode, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Node) {
                result.put(entry.getKey(), (Node)entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            Map<StringNode, Node> valueResult = this.convertMap((Map)entry.getValue());
            result.put(entry.getKey(), (Node)Node.objectNode(valueResult));
        }
        return result;
    }

    public Builder toBuilder() {
        Builder builder = SchemaDocument.builder().idKeyword(this.idKeyword).schemaKeyword(this.schemaKeyword).rootSchema(this.rootSchema).extensions(this.extensions);
        this.definitions.forEach(builder::putDefinition);
        return builder;
    }

    public Schema getRootSchema() {
        return this.rootSchema;
    }

    public Optional<String> getIdKeyword() {
        return Optional.ofNullable(this.idKeyword);
    }

    public Optional<String> getSchemaKeyword() {
        return Optional.ofNullable(this.schemaKeyword);
    }

    public Optional<Schema> getDefinition(String ref) {
        return Optional.ofNullable(this.definitions.get(ref));
    }

    public Map<String, Schema> getDefinitions() {
        return this.definitions;
    }

    public Optional<Node> getExtension(String key) {
        return this.extensions.getMember(key);
    }

    public ObjectNode getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaDocument)) {
            return false;
        }
        SchemaDocument that = (SchemaDocument)o;
        return Objects.equals(this.idKeyword, that.idKeyword) && Objects.equals(this.schemaKeyword, that.schemaKeyword) && this.rootSchema.equals(that.rootSchema) && this.definitions.equals(that.definitions) && this.extensions.equals((Object)that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.idKeyword, this.schemaKeyword, this.rootSchema);
    }

    public static final class Builder
    implements SmithyBuilder<SchemaDocument> {
        private String idKeyword;
        private String schemaKeyword;
        private Schema rootSchema;
        private ObjectNode extensions = Node.objectNode();
        private final Map<String, Schema> definitions = new LinkedHashMap<String, Schema>();

        private Builder() {
        }

        public SchemaDocument build() {
            return new SchemaDocument(this);
        }

        public Builder idKeyword(String idKeyword) {
            this.idKeyword = idKeyword;
            return this;
        }

        public Builder schemaKeyword(String schemaKeyword) {
            this.schemaKeyword = schemaKeyword;
            return this;
        }

        public Builder rootSchema(Schema rootSchema) {
            this.rootSchema = rootSchema;
            return this;
        }

        public Builder putDefinition(String name, Schema schema) {
            this.definitions.put(name, schema);
            return this;
        }

        public Builder removeDefinition(String name) {
            this.definitions.remove(name);
            return this;
        }

        public Builder extensions(ObjectNode extensions) {
            this.extensions = extensions;
            return this;
        }
    }
}

