/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.HashMap;
import java.util.Locale;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.utils.StringUtils;

@FunctionalInterface
public interface RefStrategy {
    public static final String DEFAULT_POINTER = "#/definitions";

    public String toPointer(ShapeId var1, ObjectNode var2);

    public static RefStrategy createDefaultDeconflictingStrategy(ShapeIndex index, ObjectNode config) {
        return RefStrategy.createDeconflictingStrategy(index, config, RefStrategy.createDefaultStrategy());
    }

    public static RefStrategy createDefaultStrategy() {
        return (id, config) -> {
            StringBuilder builder = new StringBuilder();
            String pointer = config.getStringMemberOrDefault("definitionPointer", DEFAULT_POINTER);
            builder.append(pointer);
            if (!pointer.endsWith("/")) {
                builder.append('/');
            }
            if (!config.containsMember("stripNamespaces")) {
                for (String part : id.getNamespace().split("\\.")) {
                    builder.append(StringUtils.capitalize((String)part));
                }
            }
            builder.append(id.getName());
            id.getMember().ifPresent(memberName -> {
                builder.append(StringUtils.capitalize((String)memberName));
                if (!memberName.toLowerCase(Locale.US).endsWith("member")) {
                    builder.append("Member");
                }
            });
            return builder.toString();
        };
    }

    public static RefStrategy createDeconflictingStrategy(ShapeIndex index, ObjectNode config, RefStrategy delegate) {
        HashMap pointers = new HashMap();
        HashMap reversePointers = new HashMap();
        index.shapes().sorted().forEach(shape -> {
            String pointer = delegate.toPointer(shape.getId(), config);
            if (!reversePointers.containsKey(pointer)) {
                pointers.put(shape.getId(), pointer);
                reversePointers.put(pointer, shape.getId());
                return;
            }
            int i = 2;
            while (true) {
                String incrementedPointer;
                if (!reversePointers.containsKey(incrementedPointer = pointer + i)) {
                    pointers.put(shape.getId(), incrementedPointer);
                    reversePointers.put(incrementedPointer, shape.getId());
                    return;
                }
                ++i;
            }
        });
        return (id, cfg) -> pointers.computeIfAbsent(id, i -> delegate.toPointer((ShapeId)i, cfg));
    }
}

