/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.JsonNameTrait;

@FunctionalInterface
public interface PropertyNamingStrategy {
    public String toPropertyName(Shape var1, MemberShape var2, ObjectNode var3);

    public static PropertyNamingStrategy createMemberNameStrategy() {
        return (containingShape, member, config) -> member.getMemberName();
    }

    public static PropertyNamingStrategy createDefaultStrategy() {
        return (containingShape, member, config) -> {
            if (config.getBooleanMemberOrDefault("useJsonName") && member.hasTrait(JsonNameTrait.class)) {
                return ((JsonNameTrait)member.getTrait(JsonNameTrait.class).get()).getValue();
            }
            return member.getMemberName();
        };
    }
}

