/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import software.amazon.smithy.jsonschema.JsonSchemaMapper;
import software.amazon.smithy.jsonschema.PropertyNamingStrategy;
import software.amazon.smithy.jsonschema.RefStrategy;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.PatternTrait;
import software.amazon.smithy.model.traits.RangeTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.TitleTrait;
import software.amazon.smithy.model.traits.UniqueItemsTrait;
import software.amazon.smithy.utils.ListUtils;

final class JsonSchemaShapeVisitor
extends ShapeVisitor.Default<Schema> {
    private static final String UNION_STRATEGY_ONE_OF = "oneOf";
    private static final String UNION_STRATEGY_OBJECT = "object";
    private static final String UNION_STRATEGY_STRUCTURE = "structure";
    private final ShapeIndex index;
    private final ObjectNode config;
    private final RefStrategy refStrategy;
    private final PropertyNamingStrategy propertyNamingStrategy;
    private final List<JsonSchemaMapper> mappers;

    JsonSchemaShapeVisitor(ShapeIndex index, ObjectNode config, RefStrategy refStrategy, PropertyNamingStrategy propertyNamingStrategy, List<JsonSchemaMapper> mappers) {
        this.index = index;
        this.config = config;
        this.refStrategy = refStrategy;
        this.propertyNamingStrategy = propertyNamingStrategy;
        this.mappers = mappers;
    }

    public Schema getDefault(Shape shape) {
        throw new UnsupportedOperationException("Unable to convert " + shape + " to JSON Schema");
    }

    public Schema documentShape(DocumentShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, null));
    }

    public Schema blobShape(BlobShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "string"));
    }

    public Schema booleanShape(BooleanShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "boolean"));
    }

    public Schema listShape(ListShape shape) {
        return this.buildSchema((Shape)shape, this.createCollectionType((CollectionShape)shape));
    }

    public Schema setShape(SetShape shape) {
        return this.buildSchema((Shape)shape, this.createCollectionType((CollectionShape)shape).uniqueItems(true));
    }

    private Schema.Builder createCollectionType(CollectionShape shape) {
        return this.createBuilder((Shape)shape, "array").items(this.createRef(shape.getMember()));
    }

    private Schema createRef(MemberShape member) {
        if (this.config.getBooleanMemberOrDefault("inlineMembers")) {
            throw new UnsupportedOperationException("inlineMembers is not yet supported");
        }
        return Schema.builder().ref(this.refStrategy.toPointer(member.getId(), this.config)).build();
    }

    public Schema mapShape(MapShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, UNION_STRATEGY_OBJECT).propertyNames(this.createRef(shape.getKey())).additionalProperties(this.createRef(shape.getValue())));
    }

    public Schema byteShape(ByteShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "number"));
    }

    public Schema shortShape(ShortShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "number"));
    }

    public Schema integerShape(IntegerShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "number"));
    }

    public Schema longShape(LongShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "number"));
    }

    public Schema floatShape(FloatShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "number"));
    }

    public Schema doubleShape(DoubleShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "number"));
    }

    public Schema bigIntegerShape(BigIntegerShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "number"));
    }

    public Schema bigDecimalShape(BigDecimalShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "number"));
    }

    public Schema stringShape(StringShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "string"));
    }

    public Schema structureShape(StructureShape shape) {
        return this.structuredShape((Shape)shape, shape.getAllMembers().values());
    }

    private Schema structuredShape(Shape container, Collection<MemberShape> memberShapes) {
        Schema.Builder builder = this.createBuilder(container, UNION_STRATEGY_OBJECT);
        ArrayList<String> required = new ArrayList<String>();
        for (MemberShape member : memberShapes) {
            String memberName = this.propertyNamingStrategy.toPropertyName(container, member, this.config);
            if (member.isRequired()) {
                required.add(memberName);
            }
            builder.putProperty(memberName, this.createRef(member));
        }
        builder.required(required);
        return this.buildSchema(container, builder);
    }

    public Schema unionShape(UnionShape shape) {
        String unionStrategy;
        switch (unionStrategy = this.config.getStringMemberOrDefault("unionStrategy", UNION_STRATEGY_ONE_OF)) {
            case "object": {
                return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, UNION_STRATEGY_OBJECT));
            }
            case "structure": {
                return this.structuredShape((Shape)shape, shape.getAllMembers().values());
            }
            case "oneOf": {
                ArrayList<Schema> schemas = new ArrayList<Schema>();
                for (MemberShape member : shape.getAllMembers().values()) {
                    String memberName = this.propertyNamingStrategy.toPropertyName((Shape)shape, member, this.config);
                    schemas.add(Schema.builder().type(UNION_STRATEGY_OBJECT).required(ListUtils.of((Object)memberName)).putProperty(memberName, this.createRef(member)).build());
                }
                return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, UNION_STRATEGY_OBJECT).type(null).oneOf(schemas));
            }
        }
        throw new UnsupportedOperationException(String.format("Unknown %s strategy: %s", "unionStrategy", unionStrategy));
    }

    public Schema timestampShape(TimestampShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "string"));
    }

    public Schema memberShape(MemberShape memberShape) {
        Shape target = this.getTarget(memberShape);
        return this.buildSchema((Shape)memberShape, this.updateBuilder((Shape)memberShape, ((Schema)target.accept((ShapeVisitor)this)).toBuilder()));
    }

    private Shape getTarget(MemberShape member) {
        return (Shape)this.index.getShape(member.getTarget()).orElseThrow(() -> new RuntimeException("Unable to find the shape targeted by " + member));
    }

    private Schema.Builder createBuilder(Shape shape, String defaultType) {
        return this.updateBuilder(shape, Schema.builder().type(defaultType));
    }

    private Schema.Builder updateBuilder(Shape shape, Schema.Builder builder) {
        shape.getTrait(DocumentationTrait.class).map(StringTrait::getValue).ifPresent(builder::description);
        shape.getTrait(TitleTrait.class).map(StringTrait::getValue).ifPresent(builder::title);
        shape.getTrait(MediaTypeTrait.class).map(StringTrait::getValue).ifPresent(builder::contentMediaType);
        shape.getTrait(PatternTrait.class).map(PatternTrait::getPattern).map(Pattern::pattern).ifPresent(builder::pattern);
        shape.getTrait(RangeTrait.class).ifPresent(t -> {
            t.getMin().ifPresent(builder::minimum);
            t.getMax().ifPresent(builder::maximum);
        });
        shape.getTrait(LengthTrait.class).ifPresent(t -> {
            block5: {
                block4: {
                    if (shape.isListShape()) break block4;
                    if (!shape.isSetShape()) break block5;
                }
                t.getMin().map(Long::intValue).ifPresent(builder::minItems);
                t.getMax().map(Long::intValue).ifPresent(builder::maxItems);
                return;
            }
            if (shape.isMapShape()) {
                t.getMin().map(Long::intValue).ifPresent(builder::minProperties);
                t.getMax().map(Long::intValue).ifPresent(builder::maxProperties);
                return;
            }
            t.getMin().ifPresent(builder::minLength);
            t.getMax().ifPresent(builder::maxLength);
        });
        if (shape.hasTrait(UniqueItemsTrait.class)) {
            builder.uniqueItems(true);
        }
        shape.getTrait(EnumTrait.class).map(EnumTrait::getValues).map(Map::keySet).ifPresent(builder::enumValues);
        return builder;
    }

    private Schema buildSchema(Shape shape, Schema.Builder builder) {
        for (JsonSchemaMapper mapper : this.mappers) {
            mapper.updateSchema(shape, builder, this.config);
        }
        return builder.build();
    }
}

