/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import software.amazon.smithy.jmespath.JmespathExpression;
import software.amazon.smithy.jmespath.Lexer;
import software.amazon.smithy.jmespath.Token;
import software.amazon.smithy.jmespath.TokenIterator;
import software.amazon.smithy.jmespath.TokenType;
import software.amazon.smithy.jmespath.ast.AndExpression;
import software.amazon.smithy.jmespath.ast.ComparatorExpression;
import software.amazon.smithy.jmespath.ast.ComparatorType;
import software.amazon.smithy.jmespath.ast.CurrentExpression;
import software.amazon.smithy.jmespath.ast.ExpressionTypeExpression;
import software.amazon.smithy.jmespath.ast.FieldExpression;
import software.amazon.smithy.jmespath.ast.FilterProjectionExpression;
import software.amazon.smithy.jmespath.ast.FlattenExpression;
import software.amazon.smithy.jmespath.ast.FunctionExpression;
import software.amazon.smithy.jmespath.ast.IndexExpression;
import software.amazon.smithy.jmespath.ast.LiteralExpression;
import software.amazon.smithy.jmespath.ast.MultiSelectHashExpression;
import software.amazon.smithy.jmespath.ast.MultiSelectListExpression;
import software.amazon.smithy.jmespath.ast.NotExpression;
import software.amazon.smithy.jmespath.ast.ObjectProjectionExpression;
import software.amazon.smithy.jmespath.ast.OrExpression;
import software.amazon.smithy.jmespath.ast.ProjectionExpression;
import software.amazon.smithy.jmespath.ast.SliceExpression;
import software.amazon.smithy.jmespath.ast.Subexpression;

final class Parser {
    private static final int PROJECTION_STOP = 10;
    private static final TokenType[] NUD_TOKENS = new TokenType[]{TokenType.CURRENT, TokenType.IDENTIFIER, TokenType.LITERAL, TokenType.STAR, TokenType.LBRACE, TokenType.LBRACKET, TokenType.FLATTEN, TokenType.EXPREF, TokenType.NOT, TokenType.FILTER, TokenType.LPAREN};
    private static final TokenType[] LED_TOKENS = new TokenType[]{TokenType.DOT, TokenType.LBRACKET, TokenType.OR, TokenType.AND, TokenType.PIPE, TokenType.FLATTEN, TokenType.FILTER, TokenType.EQUAL, TokenType.NOT_EQUAL, TokenType.GREATER_THAN, TokenType.GREATER_THAN_EQUAL, TokenType.LESS_THAN, TokenType.LESS_THAN_EQUAL, TokenType.LPAREN};
    private final String expression;
    private final TokenIterator iterator;

    private Parser(String expression) {
        this.expression = expression;
        this.iterator = Lexer.tokenize(expression);
    }

    static JmespathExpression parse(String expression) {
        Parser parser = new Parser(expression);
        JmespathExpression result = parser.expression(0);
        parser.iterator.expect(TokenType.EOF);
        return result;
    }

    private JmespathExpression expression(int rbp) {
        JmespathExpression left = this.nud();
        while (this.iterator.hasNext() && rbp < this.iterator.peek().type.lbp) {
            left = this.led(left);
        }
        return left;
    }

    private JmespathExpression nud() {
        Token token = this.iterator.expect(NUD_TOKENS);
        switch (token.type) {
            case CURRENT: {
                return new CurrentExpression(token.line, token.column);
            }
            case IDENTIFIER: {
                if (this.iterator.peek().type == TokenType.LPAREN) {
                    this.iterator.expect(TokenType.LPAREN);
                    List<JmespathExpression> arguments = this.parseList(TokenType.RPAREN);
                    return new FunctionExpression(token.value.expectStringValue(), arguments, token.line, token.column);
                }
                return new FieldExpression(token.value.expectStringValue(), token.line, token.column);
            }
            case STAR: {
                return this.parseWildcardObject(new CurrentExpression(token.line, token.column));
            }
            case LITERAL: {
                return new LiteralExpression(token.value.getValue(), token.line, token.column);
            }
            case LBRACKET: {
                return this.parseNudLbracket();
            }
            case LBRACE: {
                return this.parseNudLbrace();
            }
            case FLATTEN: {
                return this.parseFlatten(new CurrentExpression(token.line, token.column));
            }
            case EXPREF: {
                JmespathExpression expressionRef = this.expression(token.type.lbp);
                return new ExpressionTypeExpression(expressionRef, token.line, token.column);
            }
            case NOT: {
                JmespathExpression notNode = this.expression(token.type.lbp);
                return new NotExpression(notNode, token.line, token.column);
            }
            case FILTER: {
                return this.parseFilter(new CurrentExpression(token.line, token.column));
            }
            case LPAREN: {
                JmespathExpression insideParens = this.expression(0);
                this.iterator.expect(TokenType.RPAREN);
                return insideParens;
            }
        }
        throw this.iterator.syntax("Invalid nud token: " + token);
    }

    private JmespathExpression led(JmespathExpression left) {
        Token token = this.iterator.expect(LED_TOKENS);
        switch (token.type) {
            case DOT: {
                if (this.iterator.peek().type == TokenType.STAR) {
                    this.iterator.expect(TokenType.STAR);
                    return this.parseWildcardObject(left);
                }
                JmespathExpression dotRhs = this.parseDotRhs(TokenType.DOT.lbp);
                return new Subexpression(left, dotRhs, token.line, token.column);
            }
            case FLATTEN: {
                return this.parseFlatten(left);
            }
            case OR: {
                return new OrExpression(left, this.expression(token.type.lbp), token.line, token.column);
            }
            case AND: {
                return new AndExpression(left, this.expression(token.type.lbp), token.line, token.column);
            }
            case PIPE: {
                return new Subexpression(left, this.expression(token.type.lbp), token.line, token.column, true);
            }
            case FILTER: {
                return this.parseFilter(left);
            }
            case LBRACKET: {
                Token bracketToken = this.iterator.expectPeek(TokenType.NUMBER, TokenType.COLON, TokenType.STAR);
                if (bracketToken.type == TokenType.STAR) {
                    return this.parseWildcardIndex(left);
                }
                return new Subexpression(left, this.parseIndex(), token.line, token.column);
            }
            case EQUAL: {
                return this.parseComparator(ComparatorType.EQUAL, left);
            }
            case NOT_EQUAL: {
                return this.parseComparator(ComparatorType.NOT_EQUAL, left);
            }
            case GREATER_THAN: {
                return this.parseComparator(ComparatorType.GREATER_THAN, left);
            }
            case GREATER_THAN_EQUAL: {
                return this.parseComparator(ComparatorType.GREATER_THAN_EQUAL, left);
            }
            case LESS_THAN: {
                return this.parseComparator(ComparatorType.LESS_THAN, left);
            }
            case LESS_THAN_EQUAL: {
                return this.parseComparator(ComparatorType.LESS_THAN_EQUAL, left);
            }
        }
        throw this.iterator.syntax("Invalid led token: " + token);
    }

    private JmespathExpression parseNudLbracket() {
        switch (this.iterator.expectNotEof().type) {
            case NUMBER: 
            case COLON: {
                return this.parseIndex();
            }
            case STAR: {
                if (this.iterator.peek((int)1).type != TokenType.RBRACKET) break;
                return this.parseWildcardIndex(new CurrentExpression(this.iterator.line(), this.iterator.column()));
            }
        }
        return this.parseMultiList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JmespathExpression parseIndex() {
        int line = this.iterator.line();
        int column = this.iterator.column();
        Integer[] parts = new Integer[]{null, null, 1};
        int pos = 0;
        block4: while (true) {
            Token next = this.iterator.expectPeek(TokenType.NUMBER, TokenType.RBRACKET, TokenType.COLON);
            switch (next.type) {
                case NUMBER: {
                    this.iterator.expect(TokenType.NUMBER);
                    parts[pos] = next.value.expectNumberValue().intValue();
                    this.iterator.expectPeek(TokenType.COLON, TokenType.RBRACKET);
                    continue block4;
                }
                case RBRACKET: {
                    break block4;
                }
                default: {
                    this.iterator.expect(TokenType.COLON);
                    if (++pos == 3) throw this.iterator.syntax("Too many colons in slice expression");
                    continue block4;
                }
            }
            break;
        }
        this.iterator.expect(TokenType.RBRACKET);
        if (pos == 0) {
            return new IndexExpression(parts[0], line, column);
        }
        SliceExpression slice = new SliceExpression(parts[0], parts[1], parts[2], line, column);
        JmespathExpression rhs = this.parseProjectionRhs(TokenType.STAR.lbp);
        return new ProjectionExpression(slice, rhs, line, column);
    }

    private JmespathExpression parseMultiList() {
        int line = this.iterator.line();
        int column = this.iterator.column();
        List<JmespathExpression> nodes = this.parseList(TokenType.RBRACKET);
        return new MultiSelectListExpression(nodes, line, column);
    }

    private List<JmespathExpression> parseList(TokenType closing) {
        ArrayList<JmespathExpression> nodes = new ArrayList<JmespathExpression>();
        while (this.iterator.peek().type != closing) {
            nodes.add(this.expression(0));
            if (this.iterator.peek().type != TokenType.COMMA) continue;
            this.iterator.expect(TokenType.COMMA);
            if (this.iterator.peek().type != closing) continue;
            throw this.iterator.syntax("Invalid token after ',': " + this.iterator.peek());
        }
        this.iterator.expect(closing);
        return nodes;
    }

    private JmespathExpression parseNudLbrace() {
        int line = this.iterator.line();
        int column = this.iterator.column();
        LinkedHashMap<String, JmespathExpression> entries = new LinkedHashMap<String, JmespathExpression>();
        while (this.iterator.hasNext()) {
            Token key = this.iterator.expect(TokenType.IDENTIFIER);
            this.iterator.expect(TokenType.COLON);
            JmespathExpression value = this.expression(0);
            entries.put(key.value.expectStringValue(), value);
            if (this.iterator.expectPeek((TokenType[])new TokenType[]{TokenType.RBRACE, TokenType.COMMA}).type != TokenType.COMMA) break;
            this.iterator.expect(TokenType.COMMA);
        }
        this.iterator.expect(TokenType.RBRACE);
        return new MultiSelectHashExpression(entries, line, column);
    }

    private JmespathExpression parseWildcardIndex(JmespathExpression left) {
        int line = this.iterator.line();
        int column = this.iterator.column();
        this.iterator.expect(TokenType.STAR);
        this.iterator.expect(TokenType.RBRACKET);
        JmespathExpression right = this.parseProjectionRhs(TokenType.STAR.lbp);
        return new ProjectionExpression(left, right, line, column);
    }

    private JmespathExpression parseWildcardObject(JmespathExpression left) {
        int line = this.iterator.line();
        int column = this.iterator.column() - 1;
        return new ObjectProjectionExpression(left, this.parseProjectionRhs(TokenType.STAR.lbp), line, column);
    }

    private JmespathExpression parseFlatten(JmespathExpression left) {
        int line = this.iterator.line();
        int column = this.iterator.column();
        FlattenExpression flatten = new FlattenExpression(left, left.getLine(), left.getColumn());
        JmespathExpression right = this.parseProjectionRhs(TokenType.STAR.lbp);
        return new ProjectionExpression(flatten, right, line, column);
    }

    private JmespathExpression parseProjectionRhs(int lbp) {
        Token next = this.iterator.expectNotEof();
        if (next.type == TokenType.DOT) {
            this.iterator.expect(TokenType.DOT);
            return this.parseDotRhs(lbp);
        }
        if (next.type == TokenType.LBRACKET || next.type == TokenType.FILTER) {
            return this.expression(lbp);
        }
        if (next.type.lbp < 10) {
            return new CurrentExpression(next.line, next.column);
        }
        throw this.iterator.syntax("Invalid projection");
    }

    private JmespathExpression parseComparator(ComparatorType comparatorType, JmespathExpression lhs) {
        int line = this.iterator.line();
        int column = this.iterator.column();
        JmespathExpression rhs = this.expression(TokenType.EQUAL.lbp);
        return new ComparatorExpression(comparatorType, lhs, rhs, line, column);
    }

    private JmespathExpression parseDotRhs(int lbp) {
        Token token = this.iterator.expectPeek(TokenType.LBRACKET, TokenType.LBRACE, TokenType.STAR, TokenType.IDENTIFIER);
        if (token.type == TokenType.LBRACKET) {
            this.iterator.next();
            return this.parseMultiList();
        }
        return this.expression(lbp);
    }

    private JmespathExpression parseFilter(JmespathExpression left) {
        JmespathExpression condition = this.expression(0);
        this.iterator.expect(TokenType.RBRACKET);
        JmespathExpression conditionRhs = this.parseProjectionRhs(TokenType.FILTER.lbp);
        return new FilterProjectionExpression(left, condition, conditionRhs, condition.getLine(), condition.getColumn());
    }
}

