/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath.ast;

import java.util.Objects;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.JmespathExpression;

public final class IndexExpression
extends JmespathExpression {
    private final int index;

    public IndexExpression(int index) {
        this(index, 1, 1);
    }

    public IndexExpression(int index, int line, int column) {
        super(line, column);
        this.index = index;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitIndex(this);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexExpression)) {
            return false;
        }
        IndexExpression other = (IndexExpression)o;
        return this.getIndex() == other.getIndex();
    }

    public int hashCode() {
        return Objects.hash(this.getIndex());
    }

    public String toString() {
        return "IndexExpression{index=" + this.index + '}';
    }
}

