/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath.ast;

import java.util.Objects;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.JmespathExpression;

public final class FieldExpression
extends JmespathExpression {
    private final String name;

    public FieldExpression(String name) {
        this(name, 1, 1);
    }

    public FieldExpression(String name, int line, int column) {
        super(line, column);
        this.name = name;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitField(this);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldExpression)) {
            return false;
        }
        return this.getName().equals(((FieldExpression)o).getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public String toString() {
        return "FieldExpression{name='" + this.name + '\'' + '}';
    }
}

