/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.ModelDiff;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.StringUtils;

public final class ChangedMemberTarget
extends AbstractDiffEvaluator {
    private static final Set<ShapeId> SIGNIFICANT_CODEGEN_TRAITS = SetUtils.of((Object)EnumTrait.ID);
    private static final Pair<Severity, String> COMPATIBLE = Pair.of((Object)Severity.WARNING, (Object)"This was determined backward compatible.");

    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return this.evaluate(ChangedMemberTarget.class.getClassLoader(), differences);
    }

    @Override
    public List<ValidationEvent> evaluate(ClassLoader classLoader, Differences differences) {
        return differences.changedShapes(MemberShape.class).filter(change -> !((MemberShape)change.getOldShape()).getTarget().equals((Object)((MemberShape)change.getNewShape()).getTarget())).map(change -> this.createChangeEvent(classLoader, differences, (ChangedShape<MemberShape>)change)).collect(Collectors.toList());
    }

    private ValidationEvent createChangeEvent(ClassLoader classLoader, Differences differences, ChangedShape<MemberShape> change) {
        return this.createChangeEvent(classLoader, differences.getOldModel(), differences.getNewModel(), change);
    }

    private ValidationEvent createChangeEvent(ClassLoader classLoader, Model oldModel, Model newModel, ChangedShape<MemberShape> change) {
        Shape oldTarget = this.getShapeTarget(oldModel, change.getOldShape().getTarget());
        Shape newTarget = this.getShapeTarget(newModel, change.getNewShape().getTarget());
        Pair<Severity, String> evaluation = this.evaluateShape(classLoader, oldModel, newModel, oldTarget, newTarget);
        String message = ChangedMemberTarget.createSimpleMessage(change, oldTarget, newTarget) + (String)evaluation.getRight();
        return ValidationEvent.builder().severity((Severity)evaluation.getLeft()).id(this.getEventId()).shape((Shape)change.getNewShape()).message(message).build();
    }

    private Shape getShapeTarget(Model model, ShapeId id) {
        return model.getShape(id).orElse(null);
    }

    private Pair<Severity, String> evaluateShape(ClassLoader classLoader, Model oldModel, Model newModel, Shape oldShape, Shape newShape) {
        if (oldShape == null || newShape == null) {
            return COMPATIBLE;
        }
        if (oldShape.getType() != newShape.getType()) {
            return Pair.of((Object)Severity.ERROR, (Object)String.format("The type of the targeted shape changed from %s to %s.", oldShape.getType(), newShape.getType()));
        }
        if (!(oldShape instanceof SimpleShape) && !(oldShape instanceof CollectionShape) && !oldShape.isMapShape() || oldShape.isIntEnumShape() || oldShape.isEnumShape()) {
            return Pair.of((Object)Severity.ERROR, (Object)String.format("The name of a %s is significant.", oldShape.getType()));
        }
        for (ShapeId significantCodegenTrait : SIGNIFICANT_CODEGEN_TRAITS) {
            if (!oldShape.hasTrait(significantCodegenTrait)) continue;
            return Pair.of((Object)Severity.ERROR, (Object)String.format("The `%s` trait was found on the target, so the name of the targeted shape matters for codegen.", significantCodegenTrait));
        }
        Differences.Builder differences = Differences.builder().oldModel(oldModel).newModel(newModel).changedShape(new ChangedShape<Shape>(oldShape, newShape));
        if (oldShape instanceof CollectionShape) {
            MemberShape oldMember = ((CollectionShape)oldShape).getMember();
            MemberShape newMember = ((CollectionShape)newShape).getMember();
            differences.changedShape(new ChangedShape<MemberShape>(oldMember, newMember));
        } else if (oldShape instanceof MapShape) {
            MapShape oldMap = (MapShape)oldShape;
            MapShape newMap = (MapShape)newShape;
            differences.changedShape(new ChangedShape<MemberShape>(oldMap.getKey(), newMap.getKey()));
            differences.changedShape(new ChangedShape<MemberShape>(oldMap.getValue(), newMap.getValue()));
        }
        ModelDiff.Result result = ModelDiff.builder().oldModel(oldModel).newModel(newModel).classLoader(classLoader).compare(differences.build());
        ArrayList<ValidationEvent> diffEvents = new ArrayList<ValidationEvent>(result.getDiffEvents());
        if (diffEvents.isEmpty()) {
            return COMPATIBLE;
        }
        Severity severity = Severity.WARNING;
        StringBuilder message = new StringBuilder("This will result in the following effective differences:").append(System.lineSeparator()).append(System.lineSeparator());
        for (ValidationEvent event : diffEvents) {
            severity = severity.compareTo((Enum)event.getSeverity()) > 0 ? severity : event.getSeverity();
            String eventMessage = StringUtils.indent((String)event.getMessage(), (int)2).trim();
            message.append(String.format("- [%s] %s%n", event.getSeverity(), eventMessage));
        }
        if (severity.compareTo((Enum)Severity.WARNING) <= 0) {
            message.insert(0, "This was determined backward compatible. ");
        }
        return Pair.of((Object)severity, (Object)message.toString().trim());
    }

    private static String createSimpleMessage(ChangedShape<MemberShape> change, Shape oldTarget, Shape newTarget) {
        return String.format("The shape targeted by the member `%s` changed from `%s` (%s) to `%s` (%s). ", change.getShapeId(), change.getOldShape().getTarget(), oldTarget.getType(), change.getNewShape().getTarget(), newTarget.getType());
    }
}

