/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.diff.evaluators.ChangedShapeType;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.synthetic.SyntheticEnumTrait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public final class ChangedEnumTrait
extends AbstractDiffEvaluator {
    private static final String ORDER_CHANGED = ".OrderChanged.";
    private static final String NAME_CHANGED = ".NameChanged.";
    private static final String REMOVED = ".Removed.";

    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes().flatMap(change -> OptionalUtils.stream(this.getChangedEnumTraitPair((ChangedShape<Shape>)change)).map(p -> Pair.of((Object)change, (Object)p))).flatMap(pair -> this.validateEnum((ChangedShape)pair.getLeft(), (Pair<EnumTrait, EnumTrait>)((Pair)pair.getRight())).stream()).collect(Collectors.toList());
    }

    private Optional<Pair<EnumTrait, EnumTrait>> getChangedEnumTraitPair(ChangedShape<Shape> change) {
        Optional<Pair<EnumTrait, EnumTrait>> changedEnumTrait = change.getChangedTrait(EnumTrait.class);
        if (changedEnumTrait.isPresent()) {
            return changedEnumTrait;
        }
        if (ChangedShapeType.expectedStringToEnumChange(change)) {
            return Optional.of(Pair.of((Object)((EnumTrait)change.getOldShape().expectTrait(EnumTrait.class)), (Object)((EnumTrait)change.getNewShape().expectTrait(SyntheticEnumTrait.class))));
        }
        return Optional.empty();
    }

    private List<ValidationEvent> validateEnum(ChangedShape<Shape> change, Pair<EnumTrait, EnumTrait> trait) {
        EnumTrait oldTrait = (EnumTrait)trait.getLeft();
        EnumTrait newTrait = (EnumTrait)trait.getRight();
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        int oldEndPosition = oldTrait.getValues().size() - 1;
        for (int enumIndex = 0; enumIndex < oldTrait.getValues().size(); ++enumIndex) {
            EnumDefinition definition = (EnumDefinition)oldTrait.getValues().get(enumIndex);
            Optional<EnumDefinition> maybeNewValue = newTrait.getValues().stream().filter(d -> d.getValue().equals(definition.getValue())).findFirst();
            if (!maybeNewValue.isPresent()) {
                events.add(ValidationEvent.builder().severity(Severity.ERROR).message(String.format("Enum value `%s` was removed", definition.getValue())).shape(change.getNewShape()).id(this.getEventId() + REMOVED + enumIndex).build());
                --oldEndPosition;
                continue;
            }
            EnumDefinition newValue = maybeNewValue.get();
            if (newValue.getName().equals(definition.getName())) continue;
            events.add(ValidationEvent.builder().severity(Severity.ERROR).message(String.format("Enum `name` changed from `%s` to `%s` for the `%s` value", definition.getName().orElse(null), newValue.getName().orElse(null), definition.getValue())).shape(change.getNewShape()).id(this.getEventId() + NAME_CHANGED + enumIndex).build());
        }
        int newPosition = 0;
        for (EnumDefinition definition : newTrait.getValues()) {
            if (!oldTrait.getEnumDefinitionValues().contains(definition.getValue())) {
                if (newPosition <= oldEndPosition) {
                    events.add(ValidationEvent.builder().severity(Severity.ERROR).message(String.format("Enum value `%s` was inserted before the end of the list of existing values. This can cause compatibility issues when ordinal values are used for iteration, serialization, etc.", definition.getValue())).shape(change.getNewShape()).id(this.getEventId() + ORDER_CHANGED + newPosition).build());
                    ++oldEndPosition;
                } else {
                    events.add(this.note(change.getNewShape(), String.format("Enum value `%s` was appended", definition.getValue())));
                }
            }
            ++newPosition;
        }
        return events;
    }
}

