/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

public class AddedRequiredMember
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        List<ValidationEvent> events = this.newRequiredMembers(differences).map(this::emit).collect(Collectors.toList());
        return events;
    }

    private Stream<MemberShape> newRequiredMembers(Differences differences) {
        return differences.changedShapes(StructureShape.class).flatMap(change -> ((StructureShape)change.getNewShape()).members().stream().filter(newMember -> newMember.hasTrait(RequiredTrait.ID) && !newMember.hasTrait(DefaultTrait.ID) && ((StructureShape)change.getOldShape()).getAllMembers().get(newMember.getMemberName()) == null));
    }

    private ValidationEvent emit(MemberShape memberShape) {
        return ValidationEvent.builder().id(this.getEventId()).shapeId((ToShapeId)memberShape.getId()).message("Adding a new member with the `required` trait but not the `default` trait is backwards-incompatible.").severity(Severity.ERROR).build();
    }
}

