/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.validation.ValidationEvent;

public class RemovedRequiredTrait
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes(MemberShape.class).map(change -> {
            MemberShape oldShape = (MemberShape)change.getOldShape();
            MemberShape newShape = (MemberShape)change.getNewShape();
            if (oldShape.hasTrait(RequiredTrait.class) && !newShape.hasTrait(RequiredTrait.class) && !newShape.hasTrait(DefaultTrait.class) && !this.containerHasInputTrait(differences.getNewModel(), newShape)) {
                return this.error((Shape)newShape, "Removed the @required trait without replacing it with the @default trait. Code generated for this structure will change in a backward incompatible way in many languages, including Rust, Kotlin, Swift, and many others.");
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean containerHasInputTrait(Model model, MemberShape member) {
        return model.getShape(member.getContainer()).filter(container -> container.hasTrait(InputTrait.class)).isPresent();
    }
}

