/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class AddedShape
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.addedShapes().filter(shape -> !this.isMemberOfAddedShape((Shape)shape, differences)).map(shape -> this.note((Shape)shape, String.format("Added %s `%s`", shape.getType(), shape.getId()))).collect(Collectors.toList());
    }

    private boolean isMemberOfAddedShape(Shape shape, Differences differences) {
        return shape.asMemberShape().filter(member -> !differences.getOldModel().getShapeIds().contains(member.getContainer())).isPresent();
    }
}

