/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import software.amazon.smithy.codegen.core.SmithyIntegration;
import software.amazon.smithy.utils.CycleException;
import software.amazon.smithy.utils.DependencyGraph;

final class IntegrationTopologicalSort<I extends SmithyIntegration<?, ?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(IntegrationTopologicalSort.class.getName());
    private final Map<String, I> integrationLookup = new LinkedHashMap<String, I>();
    private final Map<String, Integer> insertionOrder = new HashMap<String, Integer>();
    private final DependencyGraph<String> dependencyGraph = new DependencyGraph();

    IntegrationTopologicalSort(Iterable<I> integrations) {
        for (SmithyIntegration integration : integrations) {
            SmithyIntegration previous = this.integrationLookup.put(integration.name(), integration);
            if (previous != null) {
                throw new IllegalArgumentException(String.format("Conflicting SmithyIntegration names detected for '%s': %s and %s", integration.name(), integration.getClass().getCanonicalName(), previous.getClass().getCanonicalName()));
            }
            this.insertionOrder.put(integration.name(), this.insertionOrder.size());
            this.dependencyGraph.add((Object)integration.name());
        }
        for (SmithyIntegration integration : integrations) {
            this.dependencyGraph.addDependencies((Object)integration.name(), integration.runAfter());
            for (String dependant : integration.runBefore()) {
                this.dependencyGraph.addDependency((Object)dependant, (Object)integration.name());
            }
        }
    }

    List<I> sort() {
        List sorted;
        ArrayList<SmithyIntegration> result = new ArrayList<SmithyIntegration>(this.dependencyGraph.size());
        try {
            sorted = this.dependencyGraph.toSortedList(this::compareIntegrations);
        }
        catch (CycleException e) {
            throw new IllegalArgumentException(e);
        }
        for (String name : sorted) {
            SmithyIntegration integration = (SmithyIntegration)this.integrationLookup.get(name);
            if (integration != null) {
                result.add(integration);
                continue;
            }
            this.logMissingIntegration(name);
        }
        return result;
    }

    private int compareIntegrations(String left, String right) {
        SmithyIntegration leftIntegration = (SmithyIntegration)this.integrationLookup.get(left);
        SmithyIntegration rightIntegration = (SmithyIntegration)this.integrationLookup.get(right);
        if (leftIntegration == null || rightIntegration == null) {
            return 0;
        }
        int byteResult = Byte.compare(rightIntegration.priority(), leftIntegration.priority());
        return byteResult == 0 ? Integer.compare(this.insertionOrder.get(left), this.insertionOrder.get(right)) : byteResult;
    }

    private void logMissingIntegration(String name) {
        StringBuilder message = new StringBuilder("Could not find SmithyIntegration named '");
        message.append(name).append('\'');
        if (!this.dependencyGraph.getDirectDependants((Object)name).isEmpty()) {
            message.append(" that was supposed to run before integrations [");
            message.append(String.join((CharSequence)", ", this.dependencyGraph.getDirectDependants((Object)name)));
            message.append("]");
        }
        if (!this.dependencyGraph.getDirectDependencies((Object)name).isEmpty()) {
            if (!this.dependencyGraph.getDirectDependants((Object)name).isEmpty()) {
                message.append(" and ");
            } else {
                message.append(" that ");
            }
            message.append("was supposed to run after integrations [");
            message.append(String.join((CharSequence)", ", this.dependencyGraph.getDirectDependencies((Object)name)));
            message.append("]");
        }
        LOGGER.warning(message.toString());
    }
}

